package com.biz.crm.notice.service;

import com.biz.crm.nebular.sfa.notice.req.SfaNoticeMiniReqVo;
import com.biz.crm.notice.model.SfaNoticeEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.notice.resp.SfaNoticeRespVo;
import com.biz.crm.nebular.sfa.notice.req.SfaNoticeReqVo;

import java.util.List;
import java.util.Map;

/**
 * 公告管理 接口
 *
 * @author liuhongming
 * @date 2020-09-17 17:14:42
 */
public interface ISfaNoticeService extends IService<SfaNoticeEntity> {

    /**
     * 列表
     * @param sfaNoticeReqVo
     * @return PageResult<SfaNoticeRespVo>
     */
    PageResult<SfaNoticeRespVo> findList(SfaNoticeReqVo sfaNoticeReqVo);

    /**
     * 小程序公告列表
     * @param reqVo
     * @return
     */
    PageResult<SfaNoticeRespVo> findListByMiniPrg(SfaNoticeMiniReqVo reqVo);
    /**
     * 小程序最新
     * @return
     */

    SfaNoticeRespVo queryMiniPrgNew();

    /**
     * 小程序公告详情
     * @param id
     * @return
     */
    SfaNoticeRespVo queryMiniPrg(String id);

    /**
     * 小程序公告详情(上一页/下一页)
     * @param id
     * @return
     */
    SfaNoticeRespVo queryMiniPrgByUpBelow(String id,String upBelow);


    /**
     * 查询
     * @param sfaNoticeReqVo
     * @return SfaNoticeRespVo
     */
    SfaNoticeRespVo query(SfaNoticeReqVo sfaNoticeReqVo);

    /**
     * 新增
     * @param sfaNoticeReqVo
     * @return
     */
    void save(SfaNoticeReqVo sfaNoticeReqVo);

    /**
     * 更新
     * @param sfaNoticeReqVo
     * @return
     */
    void update(SfaNoticeReqVo sfaNoticeReqVo);

    /**
     * 删除
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);
}

