package com.biz.crm.notice.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.notice.req.SfaNoticeReceivingReqVo;
import com.biz.crm.nebular.sfa.notice.resp.SfaNoticeReceivingRespVo;
import com.biz.crm.notice.mapper.SfaNoticeReceivingMapper;
import com.biz.crm.notice.model.SfaNoticeReceivingEntity;
import com.biz.crm.notice.service.ISfaNoticeReceivingService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 公告发布范围 接口实现
 *
 * @author liuhongming
 * @date 2020-09-17 17:14:43
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaNoticeReceivingServiceExpandImpl")
@Transactional
public class SfaNoticeReceivingServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaNoticeReceivingMapper, SfaNoticeReceivingEntity> implements ISfaNoticeReceivingService {

    @Resource
    private SfaNoticeReceivingMapper sfaNoticeReceivingMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    @CrmLog
    public PageResult<SfaNoticeReceivingRespVo> findList(SfaNoticeReceivingReqVo reqVo){
        Page<SfaNoticeReceivingRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaNoticeReceivingRespVo> list = sfaNoticeReceivingMapper.findList(page, reqVo);
        return PageResult.<SfaNoticeReceivingRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaNoticeReceivingRespVo
     */
    @Override
    @CrmLog
    public SfaNoticeReceivingRespVo query(SfaNoticeReceivingReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @CrmLog
    public void save(SfaNoticeReceivingReqVo reqVo){
        SfaNoticeReceivingEntity entity = CrmBeanUtil.copy(reqVo,SfaNoticeReceivingEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @CrmLog
    public void update(SfaNoticeReceivingReqVo reqVo){
        SfaNoticeReceivingEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param ids
     * @return
     */
    @Override
    @CrmLog
    public void deleteBatch(List<String> ids){
        if (CollectionUtil.listNotEmptyNotSizeZero(ids)){
            throw new BusinessException("数据主键不能为空");
        }
        List<SfaNoticeReceivingEntity> sfaNoticeReceivingEntities = sfaNoticeReceivingMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(sfaNoticeReceivingEntities)){
            sfaNoticeReceivingEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaNoticeReceivingEntities);
    }

    /**
     * 启用
     * @param ids
     * @return
     */
    @Override
    @CrmLog
    public void enableBatch(List<String> ids){
        if (CollectionUtil.listNotEmptyNotSizeZero(ids)){
            throw new BusinessException("数据主键不能为空");
        }
        //设置状态为启用
        List<SfaNoticeReceivingEntity> sfaNoticeReceivingEntities = sfaNoticeReceivingMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(sfaNoticeReceivingEntities)){
            sfaNoticeReceivingEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaNoticeReceivingEntities);
    }

    /**
     * 禁用
     * @param ids
     * @return
     */
    @Override
    @CrmLog
    public void disableBatch(List<String> ids){
        if (CollectionUtil.listNotEmptyNotSizeZero(ids)){
            throw new BusinessException("数据主键不能为空");
        }
        //设置状态为禁用
        List<SfaNoticeReceivingEntity> sfaNoticeReceivingEntities = sfaNoticeReceivingMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(sfaNoticeReceivingEntities)){
                sfaNoticeReceivingEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaNoticeReceivingEntities);
    }
}
