package com.biz.crm.picture.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.picture.service.ISfaVisitPictureService;
import com.biz.crm.nebular.sfa.picture.resp.SfaVisitPictureRespVo;
import com.biz.crm.nebular.sfa.picture.req.SfaVisitPictureReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 拜访相关照片信息 
 *
 * @author liuhongming
 * @date 2020-10-15 15:32:29
 */
@Slf4j
@RestController
@RequestMapping("/sfavisitpicture")
@Api(tags = "拜访相关照片信息 ")
public class SfaVisitPictureController {
    @Autowired
    private ISfaVisitPictureService sfaVisitPictureService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaVisitPictureRespVo>> list(@RequestBody SfaVisitPictureReqVo sfaVisitPictureReqVo) {
        PageResult<SfaVisitPictureRespVo> result=sfaVisitPictureService.findList(sfaVisitPictureReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaVisitPictureRespVo> query(@RequestBody SfaVisitPictureReqVo sfaVisitPictureReqVo) {
        SfaVisitPictureRespVo respVo=sfaVisitPictureService.query(sfaVisitPictureReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaVisitPictureReqVo sfaVisitPictureReqVo) {
        sfaVisitPictureService.save(sfaVisitPictureReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaVisitPictureReqVo sfaVisitPictureReqVo) {
        sfaVisitPictureService.update(sfaVisitPictureReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaVisitPictureReqVo sfaVisitPictureReqVo) {
        sfaVisitPictureService.deleteBatch(sfaVisitPictureReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaVisitPictureReqVo sfaVisitPictureReqVo) {
        sfaVisitPictureService.enableBatch(sfaVisitPictureReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaVisitPictureReqVo sfaVisitPictureReqVo) {
        sfaVisitPictureService.disableBatch(sfaVisitPictureReqVo);
        return Result.ok("禁用成功");
    }
}
