package com.biz.crm.picture.service;

import com.biz.crm.picture.model.SfaVisitPictureEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.picture.resp.SfaVisitPictureRespVo;
import com.biz.crm.nebular.sfa.picture.req.SfaVisitPictureReqVo;

import java.util.List;
import java.util.Map;

/**
 * 拜访相关照片信息 接口
 *
 * @author liuhongming
 * @date 2020-10-15 15:32:29
 */
public interface ISfaVisitPictureService extends IService<SfaVisitPictureEntity> {

    /**
     * 列表
     * @param sfaVisitPictureReqVo
     * @return PageResult<SfaVisitPictureRespVo>
     */
    PageResult<SfaVisitPictureRespVo> findList(SfaVisitPictureReqVo sfaVisitPictureReqVo);

    /**
     * 查询拜访图片列表（不分页）
     *
     * @param sfaVisitPictureReqVo
     * @return
     */
    List<SfaVisitPictureRespVo> findSfaVisitPictureList(SfaVisitPictureReqVo sfaVisitPictureReqVo);

    /**
     * 查询
     * @param sfaVisitPictureReqVo
     * @return SfaVisitPictureRespVo
     */
    SfaVisitPictureRespVo query(SfaVisitPictureReqVo sfaVisitPictureReqVo);

    /**
     * 新增
     * @param sfaVisitPictureReqVo
     * @return
     */
    void save(SfaVisitPictureReqVo sfaVisitPictureReqVo);

    /**
     * 更新
     * @param sfaVisitPictureReqVo
     * @return
     */
    void update(SfaVisitPictureReqVo sfaVisitPictureReqVo);

    /**
     * 删除
     * @param sfaVisitPictureReqVo
     * @return
     */
    void deleteBatch(SfaVisitPictureReqVo sfaVisitPictureReqVo);

    /**
     * 启用
     * @param sfaVisitPictureReqVo
     * @return
     */
    void enableBatch(SfaVisitPictureReqVo sfaVisitPictureReqVo);

    /**
     * 禁用
     * @param sfaVisitPictureReqVo
     * @return
     */
    void disableBatch(SfaVisitPictureReqVo sfaVisitPictureReqVo);
}

