package com.biz.crm.picture.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.picture.req.SfaVisitPictureReqVo;
import com.biz.crm.nebular.sfa.picture.resp.SfaVisitPictureRespVo;
import com.biz.crm.picture.mapper.SfaVisitPictureMapper;
import com.biz.crm.picture.model.SfaVisitPictureEntity;
import com.biz.crm.picture.service.ISfaVisitPictureService;
import com.biz.crm.util.CrmBeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 拜访相关照片信息 接口实现
 *
 * @author liuhongming
 * @date 2020-10-15 15:32:29
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaVisitPictureServiceExpandImpl")
public class SfaVisitPictureServiceImpl extends ServiceImpl<SfaVisitPictureMapper, SfaVisitPictureEntity> implements ISfaVisitPictureService {

    @Resource
    private SfaVisitPictureMapper sfaVisitPictureMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaVisitPictureRespVo> findList(SfaVisitPictureReqVo reqVo){
        Page<SfaVisitPictureRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaVisitPictureRespVo> list = sfaVisitPictureMapper.findList(page, reqVo);
        return PageResult.<SfaVisitPictureRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询拜访图片列表（不分页）
     *
     * @param sfaVisitPictureReqVo
     * @return
     */
    @Override
    public List<SfaVisitPictureRespVo> findSfaVisitPictureList(SfaVisitPictureReqVo sfaVisitPictureReqVo) {
        sfaVisitPictureReqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        sfaVisitPictureReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        return sfaVisitPictureMapper.findSfaVisitPictureList(sfaVisitPictureReqVo);
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaVisitPictureRespVo
     */
    @Override
    public SfaVisitPictureRespVo query(SfaVisitPictureReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaVisitPictureReqVo reqVo){
        SfaVisitPictureEntity entity = CrmBeanUtil.copy(reqVo,SfaVisitPictureEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaVisitPictureReqVo reqVo){
        SfaVisitPictureEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaVisitPictureReqVo reqVo){
        List<SfaVisitPictureEntity> sfaVisitPictureEntities = sfaVisitPictureMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaVisitPictureEntities)){
            sfaVisitPictureEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaVisitPictureEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaVisitPictureReqVo reqVo){
        //设置状态为启用
        List<SfaVisitPictureEntity> sfaVisitPictureEntities = sfaVisitPictureMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaVisitPictureEntities)){
            sfaVisitPictureEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitPictureEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaVisitPictureReqVo reqVo){
        //设置状态为禁用
        List<SfaVisitPictureEntity> sfaVisitPictureEntities = sfaVisitPictureMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaVisitPictureEntities)){
                sfaVisitPictureEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitPictureEntities);
    }
}
