package com.biz.crm.tpmact.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActReqVo;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActTableReqVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActRespVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActTableRespVo;
import com.biz.crm.tpmact.service.ISfaTpmActDetailExecuteService;
import com.biz.crm.tpmact.service.ISfaTpmActService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * tpm活动
 *
 * @author lf
 * @date 2021-06-10 16:44:26
 */
@Slf4j
@RestController
@RequestMapping("/sfaTpmActController")
@Api(tags = "tpm活动")
public class SfaTpmActController {
    @Autowired
    private ISfaTpmActService sfaTpmActService;
    @Autowired
    private ISfaTpmActDetailExecuteService sfaTpmActDetailExecuteService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaTpmActRespVo>> list(@RequestBody SfaTpmActReqVo sfaTpmActReqVo) {
        PageResult<SfaTpmActRespVo> result = sfaTpmActService.findList(sfaTpmActReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaTpmActRespVo> query(@RequestBody SfaTpmActReqVo sfaTpmActReqVo) {
        SfaTpmActRespVo respVo = sfaTpmActService.query(sfaTpmActReqVo);
        return Result.ok(respVo);
    }

    @PostMapping("saveTpmAct")
    @CrmLog
    @ApiOperation(value = "保存tpm活动")
    public Result saveTpmAct(@RequestParam String id) {
        sfaTpmActService.saveTpmAct(id);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "tpm活动-执行数据明细报表")
    @PostMapping("findTpmActExecuteDataTable")
    public Result<PageResult<SfaTpmActTableRespVo>> findTpmActExecuteDataTable(@RequestBody SfaTpmActTableReqVo reqVo) {
        return Result.ok(sfaTpmActService.findTpmActExecuteDataTable(reqVo));
    }

    @CrmLog
    @ApiOperation(value = "tpm活动-执行数据明细报表详情")
    @GetMapping("loadTpmActCollectDetailTableById")
    public Result<SfaTpmActTableRespVo> loadTpmActCollectDetailTableById(@RequestParam String id) {
        return Result.ok(sfaTpmActService.loadTpmActCollectDetailTableById(id));
    }


    @GetMapping("resolvingHistoryData")
    @ApiOperation(value = "解析历史的活动数据")
    public Result resolvingHistoryData() {
        sfaTpmActDetailExecuteService.resolvingHistoryData();
        return Result.ok();
    }
}
