package com.biz.crm.tpmact.controller;

import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActDetailReqVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActDetailRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.tpmact.service.ISfaTpmActDetailService;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * tpm活动明细
 *
 * @author lf
 * @date 2021-06-10 16:44:26
 */
@Slf4j
@RestController
@RequestMapping("/sfaTpmActDetailController")
@Api(tags = "tpm活动明细")
public class SfaTpmActDetailController {
    @Autowired
    private ISfaTpmActDetailService sfaTpmActDetailService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaTpmActDetailRespVo>> list(@RequestBody SfaTpmActDetailReqVo sfaTpmActDetailReqVo) {
        PageResult<SfaTpmActDetailRespVo> result=sfaTpmActDetailService.findList(sfaTpmActDetailReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaTpmActDetailRespVo> query(@RequestBody SfaTpmActDetailReqVo sfaTpmActDetailReqVo) {
        SfaTpmActDetailRespVo respVo=sfaTpmActDetailService.query(sfaTpmActDetailReqVo);
        return Result.ok(respVo);
    }

}
