package com.biz.crm.tpmact.controller;

import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmAuditCollectExamplePictureReqVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmAuditCollectExamplePictureRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.tpmact.service.ISfaTpmAuditCollectExamplePictureService;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 采集要求-照片
 *
 * @author lf
 * @date 2021-06-10 16:44:26
 */
@Slf4j
@RestController
@RequestMapping("/sfaTpmAuditCollectExamplePictureController")
@Api(tags = "采集要求-照片")
public class SfaTpmAuditCollectExamplePictureController {
    @Autowired
    private ISfaTpmAuditCollectExamplePictureService sfaTpmAuditCollectExamplePictureService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaTpmAuditCollectExamplePictureRespVo>> list(@RequestBody SfaTpmAuditCollectExamplePictureReqVo sfaTpmAuditCollectExamplePictureReqVo) {
        PageResult<SfaTpmAuditCollectExamplePictureRespVo> result=sfaTpmAuditCollectExamplePictureService.findList(sfaTpmAuditCollectExamplePictureReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaTpmAuditCollectExamplePictureRespVo> query(@RequestBody SfaTpmAuditCollectExamplePictureReqVo sfaTpmAuditCollectExamplePictureReqVo) {
        SfaTpmAuditCollectExamplePictureRespVo respVo=sfaTpmAuditCollectExamplePictureService.query(sfaTpmAuditCollectExamplePictureReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaTpmAuditCollectExamplePictureReqVo sfaTpmAuditCollectExamplePictureReqVo) {
        sfaTpmAuditCollectExamplePictureService.save(sfaTpmAuditCollectExamplePictureReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaTpmAuditCollectExamplePictureReqVo sfaTpmAuditCollectExamplePictureReqVo) {
        sfaTpmAuditCollectExamplePictureService.update(sfaTpmAuditCollectExamplePictureReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaTpmAuditCollectExamplePictureReqVo sfaTpmAuditCollectExamplePictureReqVo) {
        sfaTpmAuditCollectExamplePictureService.deleteBatch(sfaTpmAuditCollectExamplePictureReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaTpmAuditCollectExamplePictureReqVo sfaTpmAuditCollectExamplePictureReqVo) {
        sfaTpmAuditCollectExamplePictureService.enableBatch(sfaTpmAuditCollectExamplePictureReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaTpmAuditCollectExamplePictureReqVo sfaTpmAuditCollectExamplePictureReqVo) {
        sfaTpmAuditCollectExamplePictureService.disableBatch(sfaTpmAuditCollectExamplePictureReqVo);
        return Result.ok("禁用成功");
    }
}
