package com.biz.crm.tpmact.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActReqVo;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActTableReqVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActRespVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActTableRespVo;
import com.biz.crm.tpmact.model.SfaTpmActEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * tpm活动
 * 
 * @author lf
 * @date 2021-06-10 16:44:26
 */
public interface SfaTpmActMapper extends BaseMapper<SfaTpmActEntity> {
    /**
     * 列表
     * @param page
     * @param sfaTpmActReqVo
     * @return
     */
    List<SfaTpmActRespVo> findList(Page<SfaTpmActRespVo> page, @Param("vo") SfaTpmActReqVo sfaTpmActReqVo);

    /**
     * 报表
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(posCode = "svstac.create_pos_code", orgCode = "svstac.create_org_code")
    List<SfaTpmActTableRespVo> findTableList(Page<SfaTpmActTableRespVo> page, @Param("vo") SfaTpmActTableReqVo reqVo);

    /**
     * 查询活动信息
     * @param actDetailCode
     * @return
     */
    SfaTpmActRespVo findTpmActInfo(@Param("actDetailCode") String actDetailCode);
}
