package com.biz.crm.tpmact.model;

import com.biz.crm.asexecution.model.SfaAsExecutionEntity;
import com.biz.crm.asexecution.model.SfaAsTreatyEntity;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.base.CrmObjTenEntity;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.util.CrmBeanUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.math.BigDecimal;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.tpmact.model
 * @date 2021/6/22 18:48
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
public class SfaTpmActBaseEntity<T> extends CrmObjTenEntity<T> implements VisitStepListener.VisitStepListenerCommittedData{



    /**
     * 拜访计划明细id
     */
    @CrmColumn(name = "VISIT_PLAN_INFO_ID", length = 32, note = "拜访计划明细id")
    @Field(type = FieldType.Keyword)
    private String visitPlanInfoId;


    /**
     * 步骤编码
     */
    @CrmColumn(name = "STEP_CODE", length = 32, note = "步骤编码")
    private String stepCode;


    /**
     * 网点编码(网点即终端)
     */
    @CrmColumn(name = "CLIENT_CODE", length = 32, note = "网点编码(网点即终端)")
    private String clientCode;


    /**
     * 网点名称(网点即终端)
     */
    @CrmColumn(name = "CLIENT_NAME", length = 32, note = "网点名称(网点即终端)")
    private String clientName;


    /**
     * 网点类型(网点即终端)
     */
    @CrmColumn(name = "CLIENT_TYPE", length = 32, note = "网点类型(网点即终端)")
    @Field(type = FieldType.Keyword)
    private String clientType;


    /**
     * 采集类型
     */
    @CrmColumn(name = "COLLECT_TYPE", length = 64, note = "采集类型")
    private String collectType;


    /**
     * 网点类型 协访网点类型
     */
    @CrmColumn(name = "CLIENT_TYPE_NAME", length = 32, note = "网点类型 协访网点类型")
    private String clientTypeName;


    /**
     * 客户细类
     */
    @CrmColumn(name = "CLIENT_SUBCLASS", length = 32, note = "客户细类")
    @Field(type = FieldType.Keyword)
    private String clientSubclass;


    /**
     * 客户细类
     */
    @CrmColumn(name = "CLIENT_SUBCLASS_NAME", length = 32, note = "客户细类")
    private String clientSubclassName;


    /**
     * 人员账号
     */
    @CrmColumn(name = "user_name", length = 50, note = "人员账号")
    private String userName;

    /**
     * 人员姓名
     */
    @CrmColumn(name = "real_name", length = 50, note = "人员姓名")
    private String realName;

    /**
     * 职位编码
     */
    @CrmColumn(name = "pos_code", length = 50, note = "职位编码")
    private String posCode;

    /**
     * 职位名称
     */
    @CrmColumn(name = "pos_name", length = 50, note = "职位名称")
    private String posName;

    /**
     * 组织编码
     */
    @CrmColumn(name = "org_code", length = 50, note = "组织编码")
    private String orgCode;

    /**
     * 组织名称
     */
    @CrmColumn(name = "org_name", length = 50, note = "组织名称")
    private String orgName;

}
