package com.biz.crm.tpmact.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import com.biz.crm.base.CrmBaseEntity;

import java.math.BigDecimal;
import java.util.Date;

import lombok.experimental.Accessors;

/**
 * tpm活动明细商品实体类
 *
 * @author lf
 * @date 2021-06-10 16:44:26
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_tpm_act_detail_product")
@CrmTable(name = "sfa_tpm_act_detail_product", tableNote = "tpm活动明细商品")
public class SfaTpmActDetailProductEntity extends CrmExtTenEntity<SfaTpmActDetailProductEntity> {


    /**
     * 活动编码
     */
    @CrmColumn(name = "act_code", length = 64, note = "活动编码")
    private String actCode;


    /**
     * 活动明细编码
     */
    @CrmColumn(name = "act_detail_code", length = 64, note = "活动明细编码")
    private String actDetailCode;


    /**
     * 是否赠品(Y-赠品,N-本品)
     */
    @CrmColumn(name = "is_gift_product", length = 2, note = "是否赠品(Y-赠品,N-本品)")
    private String isGiftProduct;


    /**
     * 产品编码
     */
    @CrmColumn(name = "product_code", length = 64, note = "产品编码")
    private String productCode;


    /**
     * 产品名称
     */
    @CrmColumn(name = "product_name", length = 64, note = "产品名称")
    private String productName;


    /**
     * 对付方式(现金兑付,货品兑付)
     */
    @CrmColumn(name = "payment_method", length = 64, note = "对付方式(现金兑付,货品兑付)")
    private String paymentMethod;


    /**
     * 全国统一价
     */
    @CrmColumn(name = "price", mysqlType = "decimal(12,2)", oracleType = "NUMBER(12,2)", note = "全国统一价")
    private BigDecimal price;


    /**
     * 临时字段唯一值
     */
    @CrmColumn(name = "temp_uuid", length = 64, note = "临时字段唯一值")
    private String tempUuid;

    /**
     * sfa图片
     */
    @CrmColumn(name = "sfa_pic_url",length = 255,note = "sfa图片")
    private String sfaPicUrl;

    /**
     * 主图片
     */
    @CrmColumn(name = "primary_picture_url",length = 255,note = "商品主图片")
    private String primaryPictureUrl;

    /**
     * 规格
     */
    @CrmColumn(name = "spec",length = 64,note = "规格")
    private String spec;

    /**
     * 销售单位
     */
    @CrmColumn(name = "sale_unit_name",length = 32,note = "销售单位")
    private String saleUnitName;

    /**
     * 销售单位
     */
    @CrmColumn(name = "sale_unit",length = 32,note = "销售单位")
    private String saleUnit;

}
