package com.biz.crm.tpmact.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import com.biz.crm.base.CrmBaseEntity;

import java.util.Date;

import lombok.experimental.Accessors;

/**
 * 活动细类（执行控制）实体类
 *
 * @author lf
 * @date 2021-06-10 16:44:26
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_tpm_cost_type_fine")
@CrmTable(name = "sfa_tpm_cost_type_fine", tableNote = "活动细类（执行控制）")
public class SfaTpmCostTypeFineEntity extends CrmExtTenEntity<SfaTpmCostTypeFineEntity> {


    /**
     * 活动细类编码
     */
    @CrmColumn(name = "fine_code", length = 64, note = "活动细类编码")
    private String fineCode;


    /**
     * 活动细类名称
     */
    @CrmColumn(name = "fine_name", length = 64, note = "活动细类名称")
    private String fineName;


    /**
     * 是否采集活动数据(Y/N)
     */
    @CrmColumn(name = "is_collect_act_data", length = 2, note = "是否采集活动数据(Y/N)")
    private String isCollectActData;


    /**
     * 是否采集分销订单(Y/N)
     */
    @CrmColumn(name = "is_collect_distribution_order", length = 2, note = "是否采集分销订单(Y/N)")
    private String isCollectDistributionOrder;


    /**
     * 是否签署陈列协议(Y/N)
     */
    @CrmColumn(name = "is_sign_display_agreement", length = 2, note = "是否签署陈列协议(Y/N)")
    private String isSignDisplayAgreement;


    /**
     * 兑付方式(数据字典:payment_method,现金兑付,货品兑付)
     */
    @CrmColumn(name = "payment_method", length = 32, note = "兑付方式(数据字典:payment_method,现金兑付,货品兑付)")
    private String paymentMethod;

    /**
     * 是否控制活动费用(Y/N)
     */
    @CrmColumn(name = "is_control_act_fee",length = 2,note = "是否控制活动费用(Y/N)")
    private String isControlActFee;


    /**
     * 采集要求(集合的json)
     */
    @CrmColumn(name = "collect_require_list", length = 300, note = "采集要求(集合的json)")
    private String collectRequireList;

}
