package com.biz.crm.tpmact.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.moblie.controller.visit.component.VisitStepListener;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import com.biz.crm.base.CrmBaseEntity;

import java.util.Date;

import lombok.experimental.Accessors;

/**
 * 拜访步骤-tpm活动数据采集实体类
 *
 * @author lf
 * @date 2021-06-13 20:32:45
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_visit_step_tpm_act_collect")
@CrmTable(name = "sfa_visit_step_tpm_act_collect", tableNote = "拜访步骤-tpm活动数据采集")
public class SfaVisitStepTpmActCollectEntity extends SfaTpmActBaseEntity<SfaVisitStepTpmActCollectEntity>{


    /**
     * 
     */
    @CrmColumn(name = "REDIS_HASH_KEY", length = 255, note = "")
    private String redisHashKey;


    /**
     * 表单id
     */
    @CrmColumn(name = "FORM_ID", length = 32, note = "表单id")
    private String formId;


    /**
     * 采集时间-年月日 时分秒
     */
    @CrmColumn(name = "collect_time",length = 32,note = "采集时间-年月日 时分秒")
    private String collectTime;


    /**
     *采集时间-年月日
     */
    @CrmColumn(name = "collect_date",length = 32,note = "采集时间-年月日")
    private String collectDate;

    /**
     * 活动描述
     */
    @CrmColumn(name = "ACT_DESC", length = 500, note = "活动描述")
    private String actDesc;

    /**
     * 活动明细编码
     */
    @CrmColumn(name = "ACT_DETAIL_CODE",length = 64,note = "活动明细编码")
    private String actDetailCode;

}
