package com.biz.crm.tpmact.service;

import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActReqVo;
import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActTableReqVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActRespVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActTableRespVo;
import com.biz.crm.tpmact.model.SfaTpmActEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;

/**
 * tpm活动接口
 *
 * @author lf
 * @date 2021-06-10 16:44:26
 */
public interface ISfaTpmActService extends IService<SfaTpmActEntity> {

    /**
     * 列表
     * @param sfaTpmActReqVo
     * @return PageResult<SfaTpmActRespVo>
     */
    PageResult<SfaTpmActRespVo> findList(SfaTpmActReqVo sfaTpmActReqVo);

    /**
     * 查询
     * @param sfaTpmActReqVo
     * @return SfaTpmActRespVo
     */
    SfaTpmActRespVo query(SfaTpmActReqVo sfaTpmActReqVo);

    /**
     * 新增
     * @param sfaTpmActReqVo
     * @return
     */
    void save(SfaTpmActReqVo sfaTpmActReqVo);

    /**
     * tpm传输活动到sfa进行保存
     * @param actId
     */
    void saveTpmAct(String actId);


    /**
     * tpm活动传输关闭活动，sfa进行活动状态更新
     * @param actId
     */
    void closedTpmAct(String actId);


    /**
     * tpm活动完全核销传入sfa
     * @param actId
     */
    void allAudit(String actId);

    /**
     * tpm活动-执行数据明细报表
     * @param reqVo
     * @return
     */
    PageResult<SfaTpmActTableRespVo> findTpmActExecuteDataTable(SfaTpmActTableReqVo reqVo);

    /**
     * tpm活动-执行数据明细报表详情
     * @param id
     * @return
     */
    SfaTpmActTableRespVo loadTpmActCollectDetailTableById(String id);
}

