package com.biz.crm.tpmact.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.nebular.sfa.tpmact.SfaTpmActTerminalVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActDetailExecuteRespVo;
import com.biz.crm.tpmact.mapper.SfaTpmActDetailExecuteMapper;
import com.biz.crm.tpmact.model.SfaTpmActDetailExecuteEntity;
import com.biz.crm.tpmact.service.ISfaTpmActDetailExecuteService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * tpm活动明细执行表接口实现
 *
 * @author lf
 * @date 2021-07-27 16:35:28
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "SfaTpmActDetailExecuteServiceExpandImpl")
public class SfaTpmActDetailExecuteServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaTpmActDetailExecuteMapper, SfaTpmActDetailExecuteEntity> implements ISfaTpmActDetailExecuteService {

    @Resource
    private SfaTpmActDetailExecuteMapper sfaTpmActDetailExecuteMapper;


    /**
     * 保存一个终端活动的执行
     * 对于同一个终端的同一个活动，始终只保留一次
     *
     * @param respVo
     */
    @Override
    public void saveTpmActExecute(SfaTpmActDetailExecuteRespVo respVo) {
        SfaTpmActDetailExecuteEntity executeEntity = this.lambdaQuery()
                .eq(SfaTpmActDetailExecuteEntity::getActDetailCode, respVo.getActDetailCode())
                .eq(SfaTpmActDetailExecuteEntity::getTerminalCode, respVo.getTerminalCode()).one();
        if (executeEntity != null) {
            return;
        } else {
            executeEntity = new SfaTpmActDetailExecuteEntity();
            executeEntity.setActDetailCode(respVo.getActDetailCode());
            executeEntity.setTerminalCode(respVo.getTerminalCode());
            this.save(executeEntity);
        }
    }

    @Override
    public void resolvingHistoryData() {
        List<SfaTpmActDetailExecuteEntity> executeEntityList = new ArrayList<>();
        List<SfaTpmActTerminalVo> actTerminalVos = sfaTpmActDetailExecuteMapper.findTpmActTerminal();
        if (CollectionUtil.listNotEmptyNotSizeZero(actTerminalVos)) {
            Map<String, List<String>> actTerminalMap = actTerminalVos.stream()
                    .collect(Collectors.groupingBy(SfaTpmActTerminalVo::getActDetailCode))
                    .entrySet().stream().collect(Collectors.toMap(data -> data.getKey(), data -> {
                        Set<String> terminalCodes = new HashSet<>();
                        data.getValue().forEach(x -> {
                            if (StringUtils.isNotEmpty(x.getTreatyTerminalCode())) {
                                terminalCodes.add(x.getTreatyTerminalCode());
                            }
                            if (StringUtils.isNotEmpty(x.getOrderTerminalCode())) {
                                terminalCodes.add(x.getOrderTerminalCode());
                            }
                            if (StringUtils.isNotEmpty(x.getCollectTerminalCode())) {
                                terminalCodes.add(x.getCollectTerminalCode());
                            }
                        });
                        return new ArrayList(terminalCodes);
                    }));
            actTerminalMap.entrySet().forEach(data -> {
                data.getValue().forEach(x -> {
                    SfaTpmActDetailExecuteEntity entity = new SfaTpmActDetailExecuteEntity();
                    entity.setTerminalCode(x);
                    entity.setActDetailCode(data.getKey());
                    executeEntityList.add(entity);
                });
            });
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(executeEntityList)){
            this.saveBatch(executeEntityList);
        }
    }

}
