package com.biz.crm.tpmact.service.impl;

import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmActDetailProductReqVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmActDetailProductRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.*;
import com.biz.crm.tpmact.model.SfaTpmActDetailProductEntity;
import com.biz.crm.tpmact.mapper.SfaTpmActDetailProductMapper;
import com.biz.crm.tpmact.service.ISfaTpmActDetailProductService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;

/**
 * tpm活动明细商品接口实现
 *
 * @author lf
 * @date 2021-06-10 16:44:26
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaTpmActDetailProductServiceExpandImpl")
public class SfaTpmActDetailProductServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaTpmActDetailProductMapper, SfaTpmActDetailProductEntity> implements ISfaTpmActDetailProductService {

    @Resource
    private SfaTpmActDetailProductMapper sfaTpmActDetailProductMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaTpmActDetailProductRespVo> findList(SfaTpmActDetailProductReqVo reqVo){
        Page<SfaTpmActDetailProductRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaTpmActDetailProductRespVo> list = sfaTpmActDetailProductMapper.findList(page, reqVo);
        return PageResult.<SfaTpmActDetailProductRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaTpmActDetailProductRespVo
     */
    @Override
    public SfaTpmActDetailProductRespVo query(SfaTpmActDetailProductReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaTpmActDetailProductReqVo reqVo){
        SfaTpmActDetailProductEntity entity = CrmBeanUtil.copy(reqVo,SfaTpmActDetailProductEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaTpmActDetailProductReqVo reqVo){
        SfaTpmActDetailProductEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaTpmActDetailProductReqVo reqVo){

    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaTpmActDetailProductReqVo reqVo){

    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaTpmActDetailProductReqVo reqVo){

    }
}
