package com.biz.crm.tpmact.service.impl;

import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmAuditCollectExamplePictureReqVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmAuditCollectExamplePictureRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.*;
import com.biz.crm.tpmact.model.SfaTpmAuditCollectExamplePictureEntity;
import com.biz.crm.tpmact.mapper.SfaTpmAuditCollectExamplePictureMapper;
import com.biz.crm.tpmact.service.ISfaTpmAuditCollectExamplePictureService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;

/**
 * 采集要求-照片接口实现
 *
 * @author lf
 * @date 2021-06-10 16:44:26
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaTpmAuditCollectExamplePictureServiceExpandImpl")
public class SfaTpmAuditCollectExamplePictureServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaTpmAuditCollectExamplePictureMapper, SfaTpmAuditCollectExamplePictureEntity> implements ISfaTpmAuditCollectExamplePictureService {

    @Resource
    private SfaTpmAuditCollectExamplePictureMapper sfaTpmAuditCollectExamplePictureMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaTpmAuditCollectExamplePictureRespVo> findList(SfaTpmAuditCollectExamplePictureReqVo reqVo){
        Page<SfaTpmAuditCollectExamplePictureRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaTpmAuditCollectExamplePictureRespVo> list = sfaTpmAuditCollectExamplePictureMapper.findList(page, reqVo);
        return PageResult.<SfaTpmAuditCollectExamplePictureRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaTpmAuditCollectExamplePictureRespVo
     */
    @Override
    public SfaTpmAuditCollectExamplePictureRespVo query(SfaTpmAuditCollectExamplePictureReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaTpmAuditCollectExamplePictureReqVo reqVo){
        SfaTpmAuditCollectExamplePictureEntity entity = CrmBeanUtil.copy(reqVo,SfaTpmAuditCollectExamplePictureEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaTpmAuditCollectExamplePictureReqVo reqVo){
        SfaTpmAuditCollectExamplePictureEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaTpmAuditCollectExamplePictureReqVo reqVo){
        List<SfaTpmAuditCollectExamplePictureEntity> sfaTpmAuditCollectExamplePictureEntities = sfaTpmAuditCollectExamplePictureMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaTpmAuditCollectExamplePictureEntities)){
            sfaTpmAuditCollectExamplePictureEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaTpmAuditCollectExamplePictureEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaTpmAuditCollectExamplePictureReqVo reqVo){
        //设置状态为启用
        List<SfaTpmAuditCollectExamplePictureEntity> sfaTpmAuditCollectExamplePictureEntities = sfaTpmAuditCollectExamplePictureMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaTpmAuditCollectExamplePictureEntities)){
            sfaTpmAuditCollectExamplePictureEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaTpmAuditCollectExamplePictureEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaTpmAuditCollectExamplePictureReqVo reqVo){
        //设置状态为禁用
        List<SfaTpmAuditCollectExamplePictureEntity> sfaTpmAuditCollectExamplePictureEntities = sfaTpmAuditCollectExamplePictureMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaTpmAuditCollectExamplePictureEntities)){
                sfaTpmAuditCollectExamplePictureEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaTpmAuditCollectExamplePictureEntities);
    }
}
