package com.biz.crm.tpmact.service.impl;

import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmAuditCollectExampleReqVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmAuditCollectExampleRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.*;
import com.biz.crm.tpmact.model.SfaTpmAuditCollectExampleEntity;
import com.biz.crm.tpmact.mapper.SfaTpmAuditCollectExampleMapper;
import com.biz.crm.tpmact.service.ISfaTpmAuditCollectExampleService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;

/**
 * 活动细类（执行控制）接口实现
 *
 * @author lf
 * @date 2021-06-10 16:44:26
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaTpmAuditCollectExampleServiceExpandImpl")
public class SfaTpmAuditCollectExampleServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaTpmAuditCollectExampleMapper, SfaTpmAuditCollectExampleEntity> implements ISfaTpmAuditCollectExampleService {

    @Resource
    private SfaTpmAuditCollectExampleMapper sfaTpmAuditCollectExampleMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaTpmAuditCollectExampleRespVo> findList(SfaTpmAuditCollectExampleReqVo reqVo){
        Page<SfaTpmAuditCollectExampleRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaTpmAuditCollectExampleRespVo> list = sfaTpmAuditCollectExampleMapper.findList(page, reqVo);
        return PageResult.<SfaTpmAuditCollectExampleRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaTpmAuditCollectExampleRespVo
     */
    @Override
    public SfaTpmAuditCollectExampleRespVo query(SfaTpmAuditCollectExampleReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaTpmAuditCollectExampleReqVo reqVo){
        SfaTpmAuditCollectExampleEntity entity = CrmBeanUtil.copy(reqVo,SfaTpmAuditCollectExampleEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaTpmAuditCollectExampleReqVo reqVo){
        SfaTpmAuditCollectExampleEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaTpmAuditCollectExampleReqVo reqVo){
        List<SfaTpmAuditCollectExampleEntity> sfaTpmAuditCollectExampleEntities = sfaTpmAuditCollectExampleMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaTpmAuditCollectExampleEntities)){
            sfaTpmAuditCollectExampleEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaTpmAuditCollectExampleEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaTpmAuditCollectExampleReqVo reqVo){
        //设置状态为启用
        List<SfaTpmAuditCollectExampleEntity> sfaTpmAuditCollectExampleEntities = sfaTpmAuditCollectExampleMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaTpmAuditCollectExampleEntities)){
            sfaTpmAuditCollectExampleEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaTpmAuditCollectExampleEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaTpmAuditCollectExampleReqVo reqVo){
        //设置状态为禁用
        List<SfaTpmAuditCollectExampleEntity> sfaTpmAuditCollectExampleEntities = sfaTpmAuditCollectExampleMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaTpmAuditCollectExampleEntities)){
                sfaTpmAuditCollectExampleEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaTpmAuditCollectExampleEntities);
    }
}
