package com.biz.crm.tpmact.service.impl;

import com.biz.crm.nebular.sfa.tpmact.req.SfaTpmCostTypeFineReqVo;
import com.biz.crm.nebular.sfa.tpmact.resp.SfaTpmCostTypeFineRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.*;
import com.biz.crm.tpmact.model.SfaTpmCostTypeFineEntity;
import com.biz.crm.tpmact.mapper.SfaTpmCostTypeFineMapper;
import com.biz.crm.tpmact.service.ISfaTpmCostTypeFineService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;

/**
 * 活动细类（执行控制）接口实现
 *
 * @author lf
 * @date 2021-06-10 16:44:26
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaTpmCostTypeFineServiceExpandImpl")
public class SfaTpmCostTypeFineServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaTpmCostTypeFineMapper, SfaTpmCostTypeFineEntity> implements ISfaTpmCostTypeFineService {

    @Resource
    private SfaTpmCostTypeFineMapper sfaTpmCostTypeFineMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaTpmCostTypeFineRespVo> findList(SfaTpmCostTypeFineReqVo reqVo){
        Page<SfaTpmCostTypeFineRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaTpmCostTypeFineRespVo> list = sfaTpmCostTypeFineMapper.findList(page, reqVo);
        return PageResult.<SfaTpmCostTypeFineRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaTpmCostTypeFineRespVo
     */
    @Override
    public SfaTpmCostTypeFineRespVo query(SfaTpmCostTypeFineReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaTpmCostTypeFineReqVo reqVo){
        SfaTpmCostTypeFineEntity entity = CrmBeanUtil.copy(reqVo,SfaTpmCostTypeFineEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaTpmCostTypeFineReqVo reqVo){
        SfaTpmCostTypeFineEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaTpmCostTypeFineReqVo reqVo){
        List<SfaTpmCostTypeFineEntity> sfaTpmCostTypeFineEntities = sfaTpmCostTypeFineMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaTpmCostTypeFineEntities)){
            sfaTpmCostTypeFineEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaTpmCostTypeFineEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaTpmCostTypeFineReqVo reqVo){
        //设置状态为启用
        List<SfaTpmCostTypeFineEntity> sfaTpmCostTypeFineEntities = sfaTpmCostTypeFineMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaTpmCostTypeFineEntities)){
            sfaTpmCostTypeFineEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaTpmCostTypeFineEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaTpmCostTypeFineReqVo reqVo){
        //设置状态为禁用
        List<SfaTpmCostTypeFineEntity> sfaTpmCostTypeFineEntities = sfaTpmCostTypeFineMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaTpmCostTypeFineEntities)){
                sfaTpmCostTypeFineEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaTpmCostTypeFineEntities);
    }
}
