package com.biz.crm.util;

import lombok.extern.slf4j.Slf4j;

import java.math.BigDecimal;

/**
 * @author lf
 * @describe 获取经纬度距离
 * @project crm
 * @package com.biz.crm
 * @date 2021/5/28 15:23
 */
@Slf4j
public class LocationUtils {

    /**
     * 赤道半径
     */
    private static double EARTH_RADIUS = 6378.137;

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    /**
     * Description : 通过经纬度获取距离(单位：米)
     * Group :
     *
     * @param originLon      出发点经度
     * @param originLat      出发点纬度
     * @param destinationLon 目的地经度
     * @param destinationLat 目的地纬度
     * @return double
     * @author honghh
     * @date 2019/2/15 0015 9:14
     */
    public static double getDistance(BigDecimal originLon, BigDecimal originLat, BigDecimal destinationLon, BigDecimal destinationLat) {

        double radLat1 = rad(Double.parseDouble(originLat.toString()));
        double radLat2 = rad(Double.parseDouble(destinationLat.toString()));
        double a = radLat1 - radLat2;
        double b = rad(Double.parseDouble(originLon.toString())) - rad(Double.parseDouble(destinationLon.toString()));
        double s = 2 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2), 2)
                + Math.cos(radLat1) * Math.cos(radLat2)
                * Math.pow(Math.sin(b / 2), 2)));
        s = s * EARTH_RADIUS;
        // 保留两位小数
        s = Math.round(s * 100d) / 100d;
        s = s * 1000;
        return Math.abs(s);
    }
}
