package com.biz.crm.visitdealer.controller;

import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitdealer.req.SfaVisitDealerMonthlyReportReqVo;
import com.biz.crm.nebular.sfa.visitdealer.resp.SfaVisitDealerMonthlyReportRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.visitdealer.service.ISfaVisitDealerMonthlyReportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 经销商拜访月度报表;
 *
 * @author lf
 * @date 2020-11-20 11:21:59
 */
@Slf4j
@RestController
@RequestMapping("/sfaVisitDealerMonthlyReportController")
@Api(tags = "经销商拜访月度报表;")
public class SfaVisitDealerMonthlyReportController {
    @Autowired
    private ISfaVisitDealerMonthlyReportService sfaVisitDealerMonthlyReportService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaVisitDealerMonthlyReportRespVo>> list(@RequestBody SfaVisitDealerMonthlyReportReqVo sfaVisitDealerMonthlyReportReqVo) {
        PageResult<SfaVisitDealerMonthlyReportRespVo> result = sfaVisitDealerMonthlyReportService.findList(sfaVisitDealerMonthlyReportReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaVisitDealerMonthlyReportRespVo> query(@RequestBody SfaVisitDealerMonthlyReportReqVo sfaVisitDealerMonthlyReportReqVo) {
        SfaVisitDealerMonthlyReportRespVo respVo = sfaVisitDealerMonthlyReportService.query(sfaVisitDealerMonthlyReportReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaVisitDealerMonthlyReportReqVo sfaVisitDealerMonthlyReportReqVo) {
        sfaVisitDealerMonthlyReportService.save(sfaVisitDealerMonthlyReportReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaVisitDealerMonthlyReportReqVo sfaVisitDealerMonthlyReportReqVo) {
        sfaVisitDealerMonthlyReportService.update(sfaVisitDealerMonthlyReportReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        sfaVisitDealerMonthlyReportService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        sfaVisitDealerMonthlyReportService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        sfaVisitDealerMonthlyReportService.disableBatch(ids);
        return Result.ok("禁用成功");
    }


    /**
     * 定时任务生成经销商拜访月度报表
     */
    @ApiOperation(value = "定时任务生成经销商拜访月度报表")
    @PostMapping("/produceVisitDetailReport")
    @CrmLog
    @Deprecated
    @CrmAPIDiscard
    public Result produceVisitDetailReport(@RequestBody SfaVisitDealerMonthlyReportReqVo sfaVisitDealerMonthlyReportReqVo) {
        sfaVisitDealerMonthlyReportService.produceVisitDetailReport(sfaVisitDealerMonthlyReportReqVo);
        return Result.ok();
    }
}
