package com.biz.crm.visitdealer.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.sfa.visitdealer.req.SfaVisitDealerDetailReqVo;
import com.biz.crm.nebular.sfa.visitdealer.resp.SfaVisitDealerDetailRespVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitAndSalesTrendChartRespVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitRankingDetailedRespVo;
import com.biz.crm.visitdealer.model.SfaVisitDealerDetailEntity;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * 经销商拜访明细;
 * 
 * @author lf
 * @date 2020-11-17 11:22:50
 */
public interface SfaVisitDealerDetailMapper extends BaseMapper<SfaVisitDealerDetailEntity> {
    /**
     * 列表
     * @param page
     * @param sfaVisitDealerDetailReqVo
     * @return
     */
    @SqlPrivilege(orgCode = "sfa_visit_dealer_detail.visit_org_code",posCode = "sfa_visit_dealer_detail.visit_pos_code")
    List<SfaVisitDealerDetailRespVo> findList(Page<SfaVisitDealerDetailRespVo> page, @Param("vo") SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo);


    /**
     * 查询上次拜访记录
     * @param reqVo
     * @return
     */
    String selectSfaVisitDealerDetailLsatVisitSummary(@Param("vo") SfaVisitDealerDetailReqVo reqVo);


    /**
     * 通过拜访时间查询拜访记录明细
     * @param sfaVisitDealerDetailReqVo
     * @return
     */
    List<SfaVisitDealerDetailRespVo> findListByVisitDate(@Param("vo") SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo);


    /**
     * 列表
     * @param sfaVisitDealerDetailReqVo
     * @return
     */
    SfaVisitDealerDetailRespVo findSfaVisitDealerDetailRespVo(@Param("vo") SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo);

    /**
     * 查询拜访计划列表通过条件
     * @param sfaVisitDealerDetailReqVo
     * @return
     */
    List<SfaVisitDealerDetailRespVo> selectSfaVisitDealerDetailByCondition(@Param("vo") SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo);

    /**
     * 查询计划拜访数
     * @param visitType
     * @param posCode
     * @param startDate
     * @param endDate
     * @return
     */
    BigDecimal findPlanVisitNumber(@Param("visitType")String visitType,@Param("delFlag")String delFlag,
                                   @Param("posCode")String posCode,@Param("startDate")String startDate,@Param("endDate")String endDate);

    /**
     * 查询实际拜访数
     * @param visitType
     * @param posCode
     * @param startDate
     * @param endDate
     * @return
     */
    BigDecimal findActualVisitNumber(@Param("visitType")String visitType,@Param("delFlag")String delFlag,@Param("visitStatus")String visitStatus,
                                     @Param("posCode")String posCode,@Param("startDate")String startDate,@Param("endDate")String endDate);

    /**
     *  查询下单数
     * @param visitType
     * @param delFlag
     * @param visitStatus
     * @param posCode
     * @param startDate
     * @param endDate
     * @return
     */
    BigDecimal findPlaceOrderNumber(@Param("visitType")String visitType,@Param("delFlag")String delFlag,@Param("visitStatus")String visitStatus,
                                    @Param("posCode")String posCode,@Param("startDate")String startDate,@Param("endDate")String endDate);

    /**
     * 查询当前时间段被拜访过的客户数
     * @param visitType
     * @param delFlag
     * @param visitStatus
     * @param posCode
     * @param startDate
     * @param endDate
     * @return
     */
    BigDecimal findVisitCustNumber(@Param("visitType")String visitType,@Param("delFlag")String delFlag,@Param("visitStatus")String visitStatus,
                                   @Param("posCode")String posCode,@Param("startDate")String startDate,@Param("endDate")String endDate);

    /**
     * 查询对应月份  实际拜访次数
     * @param visitType
     * @param delFlag
     * @param visitStatus
     * @param posCode
     * @param monthsList
     * @return
     */
    List<SfaVisitAndSalesTrendChartRespVo> findActualVisitNumberByYm(@Param("visitType")String visitType,@Param("delFlag")String delFlag,@Param("visitStatus")String visitStatus,
                                                                     @Param("posCode")String posCode,@Param("list")List<String> monthsList);

    /**
     * 查询对应月份 销售下单数
     * @param visitType
     * @param delFlag
     * @param visitStatus
     * @param posCode
     * @param monthsList
     * @return
     */
    List<SfaVisitAndSalesTrendChartRespVo> findPlaceOrderNumberByYm(@Param("visitType")String visitType,@Param("delFlag")String delFlag,@Param("visitStatus")String visitStatus,
                                                                    @Param("posCode")String posCode,@Param("list")List<String> monthsList);


    /**
     * 多职位 查询实际拜访数
     * @param visitType
     * @param posCodeList
     * @param startDate
     * @param endDate
     * @return
     */
    List<SfaVisitRankingDetailedRespVo> findPosCodeListActualVisitNumber(@Param("visitType")String visitType, @Param("delFlag")String delFlag, @Param("visitStatus")String visitStatus,
                                                                         @Param("list")List<String> posCodeList, @Param("startDate")String startDate, @Param("endDate")String endDate);

}
