package com.biz.crm.visitdealer.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 经销商拜访明细;实体类
 *
 * @author lf
 * @date 2020-11-17 11:22:50
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_visit_dealer_detail")
@CrmTable(name = "sfa_visit_dealer_detail", tableNote = "经销商拜访明细")
public class SfaVisitDealerDetailEntity extends CrmExtTenEntity<SfaVisitDealerDetailEntity> {
    /**
     * 拜访计划编码;拜访计划编码
     */
    @CrmColumn(name = "visit_plan_code", length = 32, note = "拜访计划编码;拜访计划编码")
    private String visitPlanCode;

    /**
     * 拜访计划主键id;拜访计划主键id
     */
    @CrmColumn(name = "visit_plan_id", length = 32, note = "拜访计划主键id;拜访计划主键id")
    private String visitPlanId;

    /**
     * 人员账号;人员账号
     */
    @CrmColumn(name = "visit_user_name", length = 32, note = "人员账号;人员账号")
    private String visitUserName;

    /**
     * 人员姓名;人员姓名
     */
    @CrmColumn(name = "visit_real_name", length = 100, note = "人员姓名;人员姓名")
    private String visitRealName;

    /**
     * 人员职位编码;人员职位编码
     */
    @CrmColumn(name = "visit_pos_code", length = 32, note = "人员职位编码;人员职位编码")
    private String visitPosCode;

    /**
     * 人员职位名称;人员职位名称
     */
    @CrmColumn(name = "visit_pos_name", length = 100, note = "人员职位名称;人员职位名称")
    private String visitPosName;

    /**
     * 人员所属组织编码;人员所属组织编码
     */
    @CrmColumn(name = "visit_org_code", length = 32, note = "人员所属组织编码;人员所属组织编码")
    private String visitOrgCode;

    /**
     * 人员所属组织名称;人员所属组织名称
     */
    @CrmColumn(name = "visit_org_name", length = 100, note = "人员所属组织名称;人员所属组织名称")
    private String visitOrgName;

    /**
     * 上级组织编码
     */
    @CrmColumn(name = "visit_parent_org_code", length = 32, note = "上级组织编码")
    private String visitParentOrgCode;

    /**
     * 上级组织名称
     */
    @CrmColumn(name = "visit_parent_org_name", length = 100, note = "上级组织名称")
    private String visitParentOrgName;

    /**
     * 拜访日期;拜访日期yyyy-MM-dd
     */
    @CrmColumn(name = "visit_date", length = 32, note = "拜访日期;拜访日期yyyy-MM-dd")
    private String visitDate;

    /**
     * 拜访类型;拜访类型(临时拜访/计划拜访)
     */
    @CrmColumn(name = "visit_type", length = 32, note = "拜访类型;拜访类型(临时拜访/计划拜访)")
    private String visitType;

//    /**
//     * 客户id;客户id
//     */
//    private String clientId;

    /**
     * 客户编码;协防客户编码
     */
    @CrmColumn(name = "client_code", length = 60, note = "客户编码;协防客户编码")
    private String clientCode;

    /**
     * 客户名称;协访客户名称
     */
    @CrmColumn(name = "client_name", length = 200, note = "客户名称;协访客户名称")
    private String clientName;

    /**
     * 客户类型;协访客户类型
     */
    @CrmColumn(name = "client_type", length = 32, note = "客户类型;协访客户类型")
    private String clientType;

    /**
     * 客户电话 客户电话
     */
    @CrmColumn(name = "client_phone", length = 32, note = "客户电话 客户电话")
    private String clientPhone;

    /**
     * 客户地址;客户地址
     */
    @CrmColumn(name = "client_address", length = 512, note = "客户地址;客户地址")
    private String clientAddress;


    /**
     * 异常提交时间
     */
    @CrmColumn(name = "exception_time", length = 32, note = "异常提交时间")
    private String exceptionTime;

    /**
     * 异常描述
     */
    @CrmColumn(name = "exception_detail", length = 200, note = "异常描述")
    private String exceptionDetail;

    /**
     * 拜访总结
     */
    @CrmColumn(name = "visit_summary", length = 200, note = "拜访总结")
    private String visitSummary;

    /**
     * 进店时间
     */
    @CrmColumn(name = "in_store", length = 32, note = "进店时间")
    private String inStore;

    /**
     * 进店地址
     */
    @CrmColumn(name = "in_store_address", length = 32, note = "进店地址")
    private String inStoreAddress;

    /**
     * 进店经度
     */
    @CrmColumn(name = "in_store_longitude", mysqlType = "decimal(12,8)", oracleType = "NUMBER(12,8)", note = "进店经度")
    private BigDecimal inStoreLongitude;

    /**
     * 进店纬度
     */
    @CrmColumn(name = "in_store_latitude", mysqlType = "decimal(12,8)", oracleType = "NUMBER(12,8)", note = "进店纬度")
    private BigDecimal inStoreLatitude;

    /**
     * 离店时间
     */
    @CrmColumn(name = "out_store", length = 32, note = "离店时间")
    private String outStore;

    /**
     * 离店地址
     */
    @CrmColumn(name = "out_store_address", length = 32, note = "离店地址")
    private String outStoreAddress;

    /**
     * 离店经度
     */
    @CrmColumn(name = "out_store_longitude", mysqlType = "decimal(12,8)", oracleType = "NUMBER(12,8)", note = "离店经度")
    private BigDecimal outStoreLongitude;

    /**
     * 离店纬度
     */
    @CrmColumn(name = "out_store_latitude", mysqlType = "decimal(12,8)", oracleType = "NUMBER(12,8)", note = "离店纬度")
    private BigDecimal outStoreLatitude;

    @CrmColumn(name = "visit_date_month", length = 10, note = "创建年月")
    private String visitDateMonth;

}
