package com.biz.crm.visitdealer.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.CrmRedisHashKeyVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.moblie.controller.visit.req.SfaVisitExceptionReq;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitExceptionResp;
import com.biz.crm.nebular.mdm.customer.MdmCustomerCountReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerCountRespVo;
import com.biz.crm.moblie.controller.visit.req.SfaVisitInOutReq;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitExecuteResp;
import com.biz.crm.nebular.sfa.visitdealer.req.SfaVisitDealerDetailReqVo;
import com.biz.crm.nebular.sfa.visitdealer.resp.SfaVisitDealerDetailRespVo;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.visitdealer.model.SfaVisitDealerDetailEntity;

import java.util.List;

/**
 * 经销商拜访明细;接口
 *
 * @author lf
 * @date 2020-11-17 11:22:50
 */
public interface ISfaVisitDealerDetailService extends IService<SfaVisitDealerDetailEntity> {

    /**
     * 列表
     * @param sfaVisitDealerDetailReqVo
     * @return PageResult<SfaVisitDealerDetailRespVo>
     */
    PageResult<SfaVisitDealerDetailRespVo> findList(SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo);

    /**
     * 通过id查询拜访明细报表
     * @param id
     * @return
     */
    SfaVisitDealerDetailRespVo queryVisitDetailReportById(String id);

    /**
     * 查询
     * @param sfaVisitDealerDetailReqVo
     * @return SfaVisitDealerDetailRespVo
     */
    SfaVisitDealerDetailRespVo query(SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo);


    /**
     * 新增
     * @param sfaVisitDealerDetailReqVo
     * @return
     */
    void save(SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo);

    /**
     * 拜访-查询拜访客户信息、步骤列表
     * @param redisHashKeyVo
     * @return
     */
    SfaVisitExecuteResp getVisitSteps(CrmRedisHashKeyVo redisHashKeyVo);
    /**
     * 进店打卡
     * @param inOutReq
     */
    SfaVisitExecuteResp visitInStore(SfaVisitInOutReq inOutReq);

    /**
     * 确认为离线打卡数据
     * @param redisHashKey
     */
    void confirmVisitOffLine(String redisHashKey);

    /**
     * 离店打卡
     * @param inOutReq
     */
    void visitOutStore(SfaVisitInOutReq inOutReq);

    /**
     * 拜访步骤-进店打卡信息查询
     * @param visitId
     * @return
     */
    SfaVisitDealerDetailRespVo findVisitInStoreByVisitId(String visitId);

    /**
     * 拜访步骤-离店打卡信息查询
     * @param visitId
     * @return
     */
    SfaVisitDealerDetailRespVo findVisitOutStoreByVisitId(String visitId);


    /**
     * 拜访步骤-拜访总结信息查询
     * @param visitId
     * @return
     */
    SfaVisitDealerDetailRespVo findVisitSummaryByVisitId(String visitId);

    /**
     * 更新
     * @param sfaVisitDealerDetailReqVo
     * @return
     */
    void update(SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo);



    /**
     * 拜访异常提报
     * @param exceptionReq
     * @return
     */
    SfaVisitExceptionResp visitException(SfaVisitExceptionReq exceptionReq);

    /**
     * 删除
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);

    /**
     * 查询经销商拜访明细报表
     * @param reqVo
     * @return
     */
    PageResult<SfaVisitDealerDetailRespVo> findDealerDetailReportList(SfaVisitDealerDetailReqVo reqVo);

    /**
     * 查询拜访完成的经销商数据信息
     * @param reqVo
     * @return
     */
    List<SfaVisitPlanInfoRespVo> findSfaVisitMapComplete(SfaVisitPlanInfoReqVo reqVo);

    /**
     * 查询本期对应拜访数
     * @param reqVo
     * @return
     */
    MdmCustomerCountRespVo findVisitNumber(MdmCustomerCountReqVo reqVo);
}

