package com.biz.crm.visitdealer.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitdealer.req.SfaVisitDealerMonthlyReportReqVo;
import com.biz.crm.nebular.sfa.visitdealer.resp.SfaVisitDealerMonthlyReportRespVo;
import com.biz.crm.visitdealer.model.SfaVisitDealerMonthlyReportEntity;

import java.util.List;

/**
 * 经销商拜访月度报表;接口
 *
 * @author lf
 * @date 2020-11-20 11:21:59
 */
public interface ISfaVisitDealerMonthlyReportService extends IService<SfaVisitDealerMonthlyReportEntity> {

    /**
     * 列表
     *
     * @param sfaVisitDealerMonthlyReportReqVo
     * @return PageResult<SfaVisitDealerMonthlyReportRespVo>
     */
    PageResult<SfaVisitDealerMonthlyReportRespVo> findList(SfaVisitDealerMonthlyReportReqVo sfaVisitDealerMonthlyReportReqVo);

    /**
     * 查询
     *
     * @param sfaVisitDealerMonthlyReportReqVo
     * @return SfaVisitDealerMonthlyReportRespVo
     */
    SfaVisitDealerMonthlyReportRespVo query(SfaVisitDealerMonthlyReportReqVo sfaVisitDealerMonthlyReportReqVo);

    /**
     * 新增
     *
     * @param sfaVisitDealerMonthlyReportReqVo
     * @return
     */
    void save(SfaVisitDealerMonthlyReportReqVo sfaVisitDealerMonthlyReportReqVo);

    /**
     * 更新
     *
     * @param sfaVisitDealerMonthlyReportReqVo
     * @return
     */
    void update(SfaVisitDealerMonthlyReportReqVo sfaVisitDealerMonthlyReportReqVo);

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);

    /**
     * 生成头天的任务明细月度报表
     *
     * @param sfaVisitDealerMonthlyReportReqVo
     */
    void produceVisitDetailReport(SfaVisitDealerMonthlyReportReqVo sfaVisitDealerMonthlyReportReqVo);
}

