package com.biz.crm.visitdealer.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.sfa.visitdealer.req.SfaVisitDealerDetailReqVo;
import com.biz.crm.nebular.sfa.visitdealer.req.SfaVisitDealerMonthlyReportReqVo;
import com.biz.crm.nebular.sfa.visitdealer.resp.SfaVisitDealerDetailRespVo;
import com.biz.crm.nebular.sfa.visitdealer.resp.SfaVisitDealerMonthlyReportRespVo;
import com.biz.crm.util.*;
import com.biz.crm.visitdealer.mapper.SfaVisitDealerDetailMapper;
import com.biz.crm.visitdealer.mapper.SfaVisitDealerMonthlyReportMapper;
import com.biz.crm.visitdealer.model.SfaVisitDealerMonthlyReportEntity;
import com.biz.crm.visitdealer.service.ISfaVisitDealerMonthlyReportService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 经销商拜访月度报表;接口实现
 *
 * @author lf
 * @date 2020-11-20 11:21:59
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "SfaVisitDealerMonthlyReportServiceExpandImpl")
public class SfaVisitDealerMonthlyReportServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaVisitDealerMonthlyReportMapper, SfaVisitDealerMonthlyReportEntity> implements ISfaVisitDealerMonthlyReportService {

    @Resource
    private SfaVisitDealerMonthlyReportMapper sfaVisitDealerMonthlyReportMapper;
    @Resource
    private SfaVisitDealerDetailMapper sfaVisitDealerDetailMapper;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private MdmOrgFeign mdmOrgFeign;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;

    /**
     * 列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaVisitDealerMonthlyReportRespVo> findList(SfaVisitDealerMonthlyReportReqVo reqVo) {
        Page<SfaVisitDealerMonthlyReportRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        String orgCode = UserUtils.getUser().getOrgcode();
        if (StringUtils.isEmpty(orgCode)) {
            return PageResult.<SfaVisitDealerMonthlyReportRespVo>builder()
                    .data(Lists.newArrayList())
                    .count(page.getTotal())
                    .build();
        }
//        MdmOrgReqVo mdmOrgReqVo = new MdmOrgReqVo() {{
//            this.setOrgCode(orgCode);
//        }};
//        Result<List<MdmOrgRespVo>> result = mdmOrgFeign.findSingleChildrenOrgList(mdmOrgReqVo);
//        List<String> orgCodeList = null;
//        if (result != null && result.isSuccess()) {
//            if (CollectionUtil.listNotEmptyNotSizeZero(result.getResult())) {
//                orgCodeList = result.getResult().stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
//                reqVo.setVisitOrgCodeList(orgCodeList);
//            } else {
//                orgCodeList = Lists.newArrayList(orgCode);
//                reqVo.setVisitOrgCodeList(orgCodeList);
//            }
//        }
        List<SfaVisitDealerMonthlyReportRespVo> list = sfaVisitDealerMonthlyReportMapper.findList(page, reqVo);
        return PageResult.<SfaVisitDealerMonthlyReportRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     *
     * @param reqVo
     * @return sfaVisitDealerMonthlyReportRespVo
     */
    @Override
    public SfaVisitDealerMonthlyReportRespVo query(SfaVisitDealerMonthlyReportReqVo reqVo) {
        return null;
    }

    /**
     * 新增
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaVisitDealerMonthlyReportReqVo reqVo) {
        SfaVisitDealerMonthlyReportEntity entity = CrmBeanUtil.copy(reqVo, SfaVisitDealerMonthlyReportEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaVisitDealerMonthlyReportReqVo reqVo) {
        SfaVisitDealerMonthlyReportEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids) {
        if (CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("数据主键为空");
        }
        List<SfaVisitDealerMonthlyReportEntity> sfaVisitDealerMonthlyReportEntities = sfaVisitDealerMonthlyReportMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(sfaVisitDealerMonthlyReportEntities)) {
            sfaVisitDealerMonthlyReportEntities.forEach(o -> {
                o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaVisitDealerMonthlyReportEntities);
    }

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(List<String> ids) {
        if (CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("数据主键为空");
        }
        //设置状态为启用
        List<SfaVisitDealerMonthlyReportEntity> sfaVisitDealerMonthlyReportEntities = sfaVisitDealerMonthlyReportMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(sfaVisitDealerMonthlyReportEntities)) {
            sfaVisitDealerMonthlyReportEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitDealerMonthlyReportEntities);
    }

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(List<String> ids) {
        if (CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("数据主键为空");
        }
        //设置状态为禁用
        List<SfaVisitDealerMonthlyReportEntity> sfaVisitDealerMonthlyReportEntities = sfaVisitDealerMonthlyReportMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(sfaVisitDealerMonthlyReportEntities)) {
            sfaVisitDealerMonthlyReportEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitDealerMonthlyReportEntities);
    }


    /**
     * 定时任务生成头天的经销商拜访月度报表明细
     *
     * @param sfaVisitDealerMonthlyReportReqVo
     */
    @Override
    @CrmAPIDiscard
    @Deprecated
    public void produceVisitDetailReport(SfaVisitDealerMonthlyReportReqVo sfaVisitDealerMonthlyReportReqVo) {
        //获取前一天数据
        LocalDate localDate = LocalDate.now().plusDays(-1);
        String yesterday = localDate.format(CrmDateUtils.yyyyMMdd);
        String year = String.valueOf(localDate.getYear());
        String month = String.valueOf(localDate.getMonthValue());
        String mothOneDay = localDate.with(TemporalAdjusters.firstDayOfMonth()).format(CrmDateUtils.yyyyMMdd);
        SfaVisitDealerDetailReqVo reqVo = new SfaVisitDealerDetailReqVo() {{
            this.setStartTime(mothOneDay);
            this.setEndTime(yesterday);
            this.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            this.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        }};
        sfaVisitDealerMonthlyReportReqVo.setVisitYear(year);
        sfaVisitDealerMonthlyReportReqVo.setVisitMonth(month);
        List<SfaVisitDealerDetailRespVo> dealerDetailRespVoList = sfaVisitDealerDetailMapper.findListByVisitDate(reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(dealerDetailRespVoList)) {
            //通过用户分组数据信息
            Map<String, List<SfaVisitDealerDetailRespVo>> visitDealerDetailList = dealerDetailRespVoList.stream().
                    collect(Collectors.groupingBy(data -> fetchGroupKey(data)));
            if (visitDealerDetailList != null && visitDealerDetailList.size() > 0) {
                for (Map.Entry<String, List<SfaVisitDealerDetailRespVo>> map : visitDealerDetailList.entrySet()) {
                    List<SfaVisitDealerDetailRespVo> dealerDetailRespVos = map.getValue();
                    this.assemblingParam(dealerDetailRespVos, sfaVisitDealerMonthlyReportReqVo);
                }
            }
        }
    }


    /**
     * 设置唯一key
     *
     * @param respVo
     * @return
     */
    private String fetchGroupKey(SfaVisitDealerDetailRespVo respVo) {
        return respVo.getVisitUserName() + "_" + respVo.getVisitPosCode() + "_" + respVo.getVisitOrgCode();
    }

    /**
     * 装配数据
     *
     * @param respVos
     * @param reqVo
     */
    private void assemblingParam(List<SfaVisitDealerDetailRespVo> respVos, SfaVisitDealerMonthlyReportReqVo reqVo) {
        SfaVisitDealerDetailRespVo respVo = respVos.get(0);
        reqVo.setVisitUserName(respVo.getVisitUserName());
        reqVo.setVisitRealName(respVo.getVisitRealName());
        reqVo.setVisitOrgCode(respVo.getVisitOrgCode());
        reqVo.setVisitOrgName(respVo.getVisitOrgName());
        reqVo.setVisitPosCode(respVo.getVisitPosCode());
        reqVo.setVisitPosName(respVo.getVisitPosName());
        reqVo.setVisitParentOrgCode(respVo.getVisitParentOrgCode());
        reqVo.setVisitParentOrgName(respVo.getVisitParentOrgName());
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        reqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        QueryWrapper<SfaVisitDealerMonthlyReportEntity> queryWrapper = new QueryWrapper<SfaVisitDealerMonthlyReportEntity>()
                .eq("visit_pos_code", reqVo.getVisitPosCode())
                .eq("visit_org_code", reqVo.getVisitOrgCode())
                .eq("visit_user_name", reqVo.getVisitUserName())
                .eq("visit_year", reqVo.getVisitYear())
                .eq("visit_month", reqVo.getVisitMonth());
        SfaVisitDealerMonthlyReportEntity entity = sfaVisitDealerMonthlyReportMapper.selectOne(queryWrapper);
        //已拜访客户总次数 - (该人员当月拜访明细报表里面的已拜访的明细数量)
        Long visitAlreadyNum = respVos.stream().filter(data -> data.getVisitStatus().equals(SfaVisitEnum.visitStatus.V3.getVal())
                || data.getVisitStatus().equals(SfaVisitEnum.visitStatus.V4.getVal())).count();
        //当月拜访客户总数
        Integer visitClientNum = respVos.stream().collect(Collectors.groupingBy(SfaVisitDealerDetailRespVo::getClientCode)).size();
        //销售人员客户数 - (当前职位及下级职位的所有客户数)
        Integer saleClientNum = 0;
        //查询当前职位下的所有职位信息
        Result<Integer> dealerResult = mdmCustomerMsgFeign.findCurrentPositionRelationCustomerCount(reqVo.getVisitPosCode());
//        Result<Long> terminalResult = mdmTerminalFeign.findPositionRelationTerminalCount(reqVo.getVisitPosCode());
//        Result<Long> batchDealerResult = mdmTerminalFeign.findPositionRelationTerminalCustomerCount(reqVo.getVisitPosCode());
        if (dealerResult.isSuccess()) {
            if (StringUtils.isNotEmpty(dealerResult.getResult().toString())) {
                saleClientNum = saleClientNum + dealerResult.getResult();
            }
        }
//        if (terminalResult.isSuccess()) {
//            if (StringUtils.isNotEmpty(terminalResult.getResult().toString())) {
//                saleClientNum = saleClientNum + Integer.valueOf(terminalResult.getResult().toString());
//            }
//        }
//        if (batchDealerResult.isSuccess()) {
//            if (StringUtils.isNotEmpty(batchDealerResult.getResult().toString())) {
//                saleClientNum = saleClientNum + Integer.valueOf(batchDealerResult.getResult().toString());
//            }
//        }

        //未拜访客户数 - (销售人员客户数-拜访客户数)
        Integer visitNotClientNum = 0;
        //客户拜访率 - (拜访客户数/销售人员客户数)
        BigDecimal visitClientProbability = BigDecimal.ZERO;
        if (saleClientNum != 0) {
            visitNotClientNum = (saleClientNum - visitClientNum)>0?(saleClientNum - visitClientNum):0;
            visitClientProbability = new BigDecimal(visitClientNum).divide(new BigDecimal(saleClientNum),2, BigDecimal.ROUND_DOWN);
            if (visitClientProbability.compareTo(BigDecimal.ONE)>0){
                visitClientProbability = BigDecimal.ONE.multiply(new BigDecimal(100));
            }else {
                visitClientProbability = visitClientProbability.multiply(new BigDecimal(100));
            }
        }
        if (entity != null) {
            entity.setVisitAlreadyNum(visitAlreadyNum.toString());
            entity.setVisitClientNum(visitClientNum.toString());
            entity.setVisitNotClientNum(visitNotClientNum.toString());
            entity.setVisitClientProbability(visitClientProbability.toString());
            entity.setSaleClientNum(saleClientNum.toString());
            this.updateById(entity);
        } else {
            reqVo.setVisitAlreadyNum(visitAlreadyNum.toString());
            reqVo.setVisitClientNum(visitClientNum.toString());
            reqVo.setVisitNotClientNum(visitNotClientNum.toString());
            reqVo.setVisitClientProbability(visitClientProbability.toString());
            reqVo.setSaleClientNum(saleClientNum.toString());
            SfaVisitDealerMonthlyReportEntity monthlyReportEntity = CrmBeanUtil.copy(reqVo, SfaVisitDealerMonthlyReportEntity.class);
            this.save(monthlyReportEntity);
        }
    }
}