package com.biz.crm.visitinfo.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.mdm.LoginFromTypeEnum;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitAndSalesTrendChartRespVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitRankingRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.visitinfo.req.VisitAndSalesReq;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.visitinfo.service.impl.SfaVisitPlanInfoServiceEsImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 拜访计划明细;
 *
 * @author Xiao
 * @date 2020-09-30 10:26:35
 */
@Slf4j
@RestController
@RequestMapping("/sfaVisitPlanInfoController")
@Api(tags = "拜访计划明细")
public class SfaVisitPlanInfoController {
    @Resource
    private ISfaVisitPlanInfoService sfaVisitPlanInfoService;
    @Resource
    private SfaVisitPlanInfoServiceEsImpl sfaVisitPlanInfoServiceEsImpl;


    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    @CrmDictMethod
    public Result<SfaVisitPlanInfoRespVo> query(@RequestBody SfaVisitPlanInfoReqVo sfaVisitPlanInfoReqVo) {
        SfaVisitPlanInfoRespVo respVo=sfaVisitPlanInfoService.query(sfaVisitPlanInfoReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @Deprecated
    @CrmDictMethod
    @CrmLog
    public Result save(@RequestBody SfaVisitPlanInfoReqVo sfaVisitPlanInfoReqVo) {
//        sfaVisitPlanInfoService.addForTempPlan(sfaVisitPlanInfoReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    @CrmDictMethod
    @Deprecated
    public Result update(@RequestBody SfaVisitPlanInfoReqVo sfaVisitPlanInfoReqVo) {
        sfaVisitPlanInfoService.update(sfaVisitPlanInfoReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除拜访计划明细
     */
    @ApiOperation(value = "删除拜访计划明细")
    @PostMapping("/delete")
    @CrmLog
    public Result deleteBatch(@RequestBody List<String> ids) {

        sfaVisitPlanInfoService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmDictMethod
    @Deprecated
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        sfaVisitPlanInfoService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmDictMethod
    @Deprecated
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        sfaVisitPlanInfoService.disableBatch(ids);
        return Result.ok("禁用成功");
    }


    /**
     *拜访与销售走势图
     */
    @ApiOperation(value = "拜访与销售走势图")
    @PostMapping("/findVisiAndSalesTrendChart")
    @CrmLog
    public Result<List<SfaVisitAndSalesTrendChartRespVo>> findVisiAndSalesTrendChart(@RequestBody VisitAndSalesReq req){
        return Result.ok(sfaVisitPlanInfoService.findVisiAndSalesTrendChart(req));
    }

    @ApiOperation(value = "近段时间拜访排行")
    @PostMapping("/findVisitRankingList")
    @CrmLog
    public Result<SfaVisitRankingRespVo> findVisitRankingList(){
        return Result.ok(sfaVisitPlanInfoService.findVisitRankingList());
    }


    @ApiOperation(value = "解析拜访计划明细执行数据")
    @GetMapping("updateVisitPlanInfo")
    public Result updateVisitPlanInfo(){
        sfaVisitPlanInfoService.updateVisitPlanInfo();
        return Result.ok();
    }
}
