package com.biz.crm.visitinfo.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.visitinfo.model.SfaVisitCompleteInfoEntity;
import com.biz.crm.visitinfo.req.VisitCompleteInfoSearchReqVo;
import com.biz.crm.visitinfo.resp.report.SfaVisitCompleteInfoRespVo;
import org.apache.ibatis.annotations.Param;
import java.util.List;

/**
 * 拜访完成进度报表
 * @author YuanZiJian
 * @date 2021/3/26 16:57
 * @version: V1.0
 */
public interface SfaVisitCompleteInfoMapper extends BaseMapper<SfaVisitCompleteInfoEntity> {
    @SqlPrivilege(orgCode = "SI.VISIT_ORG_CODE",posCode = "SI.VISIT_POS_CODE")
    List<SfaVisitCompleteInfoEntity> getVisitCompleteInfoDailyList(Page<VisitCompleteInfoSearchReqVo> page, @Param("searchVo") VisitCompleteInfoSearchReqVo visitCompleteInfoSearchReqVo);
    @SqlPrivilege(orgCode = "SI.VISIT_ORG_CODE",posCode = "SI.VISIT_POS_CODE")
    List<SfaVisitCompleteInfoEntity> getVisitCompleteInfoMonthList(Page<SfaVisitCompleteInfoRespVo> page, @Param("searchVo") VisitCompleteInfoSearchReqVo visitCompleteInfoSearchReqVo);
}
