package com.biz.crm.visitinfo.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoStepFormRespVo;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.req.GetVisitReportsPageReq;
import com.biz.crm.visitstep.req.GetVisitStepAbnormalReq;
import com.biz.crm.visitstep.resp.SfaVisitStepAbnormalTableRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 拜访计划;
 *
 * @author Xiao
 * @date 2020-09-30 10:26:35
 */
public interface SfaVisitPlanInfoMapper extends BaseMapper<SfaVisitPlanInfoEntity> {


    /**
     * 查询sfa拜访计划列表
     *
     * @param sfaVisitPlanInfoReqVo
     * @return
     */
    List<SfaVisitPlanInfoRespVo> findSfaMapList(@Param("vo") SfaVisitPlanInfoReqVo sfaVisitPlanInfoReqVo);

    /**
     * 通过拜访编码以及当前时间进行删除未来的拜访计划
     *
     * @param visitPlanCodes
     * @param date
     * @return
     */
    Integer deleteVisitPlanInfo(@Param("visitPlanCodes") List<String> visitPlanCodes, @Param("date") String date);


    /**
     * 查询所有被协防的网点信息
     *
     * @param sfaVisitPlanInfoReqVo
     * @return
     */
    List<SfaVisitPlanInfoRespVo> findAllSfaVisitPlanInfo(@Param("vo") SfaVisitPlanInfoReqVo sfaVisitPlanInfoReqVo);

    /**
     * 异常提报列表
     *
     * @param req
     * @param page
     * @return
     */
    @SqlPrivilege(posCode = "svpi.VISIT_POS_CODE", orgCode = "svpi.VISIT_ORG_CODE")
    List<SfaVisitStepAbnormalTableRespVo> findAbnormalList(Page<SfaVisitStepAbnormalTableRespVo> page, @Param("vo") GetVisitStepAbnormalReq req);

    /**
     * 查询拜访明细数据步骤解析list
     * @param page
     * @param visitDate
     * @return
     */
    List<SfaVisitPlanInfoStepFormRespVo> findVisitPlanInfoStepFormList(Page<SfaVisitPlanInfoStepFormRespVo> page, @Param("visitDate") String visitDate);

    /**
     * 查询拜访明细表数据
     *
     * @param page
     * @param req
     * @return
     */
    @SqlPrivilege(posCode = "i.visit_pos_code", orgCode = "i.visit_org_code")
    List<SfaVisitPlanInfoRespVo> findVisitPlanInfoReport(Page<SfaVisitPlanInfoRespVo> page, @Param("vo") GetVisitReportsPageReq req);

    /**
     * 解析拜访明细数据执行数据关联
     * @return
     */
    List<SfaVisitPlanInfoStepFormRespVo> findVisitPlanInfoRelExecution();
}
