package com.biz.crm.visitinfo.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.visitinfo.model
 * @date 2021/7/18 14:06
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@CrmTable(name = "sfa_visit_info_step_form", tableNote = "拜访明细步骤表单")
@TableName("sfa_visit_info_step_form")
public class SfaVisitInfoStepFormEntity extends CrmBaseEntity<SfaVisitInfoStepFormEntity> {

    @CrmColumn(name = "visit_plan_info_id", length = 32, note = "拜访明细id")
    private String visitPlanInfoId;

    @CrmColumn(name = "visit_plan_code", length = 32, note = "拜访明细编码")
    private String visitPlanCode;

    @CrmColumn(name = "form_id", length = 32, note = "表单id")
    private String formId;

    @CrmColumn(name = "step_code", length = 64, note = "步骤编码")
    private String stepCode;

    @CrmColumn(name = "is_success", length = 5, note = "是否完成")
    private String isSuccess;

    @CrmColumn(name = "is_success_desc", length = 12, note = "是否完成")
    private String isSuccessDesc;

    @CrmColumn(name = "do_not", length = 5, note = "是否必做")
    private String doNot;

    @CrmColumn(name = "do_not_desc", length = 12, note = "是否必做描述")
    private String doNotDesc;

    @CrmColumn(name = "sort_num", mysqlType = "int(2)", oracleType = "NUMBER(2,0)", note = "排序")
    private Integer sortNum;
}
