package com.biz.crm.visitinfo.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.base.SfaClientData;
import com.biz.crm.common.param.RedisParam;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.req.ClientReq;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryEntity;
import com.google.common.collect.Maps;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.elasticsearch.annotations.*;

import javax.persistence.Index;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

/**
 * 拜访计划明细
 *
 * @author Xiao
 * @date 2020-09-30 10:26:35
 */
@Getter
@Setter
@TableName(SfaVisitPlanInfoEntity.TABLE_NAME)
@Document(indexName = SfaVisitPlanInfoEntity.TABLE_NAME, type = SfaVisitPlanInfoEntity.TABLE_NAME)
@CrmTable(name = SfaVisitPlanInfoEntity.TABLE_NAME, tableNote = "拜访计划明细", indexes = {
        @Index(name = SfaVisitPlanInfoEntity.TABLE_NAME + "_index1", columnList = "visit_big_type, client_code, visit_pos_code, visit_user_name, visit_org_code"),
        @Index(name = SfaVisitPlanInfoEntity.TABLE_NAME + "_index2", columnList = "visit_date")})
public class SfaVisitPlanInfoEntity extends CrmExtTenEntity<SfaVisitPlanInfoEntity> implements ClientReq {
    public static SfaVisitPlanInfoEntity getInstance() {
        return Instance.instance;
    }

    private static class Instance {
        private static final SfaVisitPlanInfoEntity instance = new SfaVisitPlanInfoEntity();
    }

    /**
     * 缓存时间秒
     */
    public static final long CACHE_TIME = 3600 * 24 * 15;
    public static final String TABLE_NAME = "sfa_visit_plan_info";

    /**
     * 获取当前用户指定拜访日期的 redisHash
     *
     * @return
     */
    public StringJoiner redisHashCurrent(String visitDate, String visitBigType) {
        UserRedis userRedis = UserUtils.getUser();
        if (null == userRedis) {
            throw new BusinessException("生成redishash失败，请重新登陆！");
        }
        return this.redisHash(visitDate, userRedis.getUsername(), userRedis.getPoscode(), visitBigType);
    }

    /**
     * 获取用户指定拜访日期的 redisHash
     *
     * @param visitDate
     * @param visitUserName
     * @param visitPosCode
     * @return
     */
    public StringJoiner redisHash(String visitDate, String visitUserName, String visitPosCode, String visitBigType) {
        if (StringUtils.isBlank(visitDate)) {
            throw new BusinessException("生成redishash失败，请指定拜访日期！");
        }
        if (StringUtils.isBlank(visitUserName)) {
            throw new BusinessException("生成redishash失败，请指定拜访用户！");
        }
        if (StringUtils.isBlank(visitPosCode)) {
            throw new BusinessException("生成redishash失败，请指定拜访用户职位！");
        }
        if (StringUtils.isBlank(visitPosCode)) {
            throw new BusinessException("生成redishash失败，请指定拜访大类！");
        }
        StringJoiner joiner = new StringJoiner(RedisParam.DELIMITER);
        joiner.add(RedisParam.SFA_VISIT).add(SfaVisitPlanInfoEntity.TABLE_NAME).add(visitBigType)
                .add(visitUserName).add(visitPosCode).add(visitDate);
        return joiner;
    }

    public StringJoiner redisHash() {
        if (StringUtils.isBlank(this.visitBigType)) {
            throw new BusinessException("生成redishash失败，请指定拜访大类！");
        }
        if (StringUtils.isBlank(this.visitDate)) {
            throw new BusinessException("生成redishash失败，请指定拜访日期！");
        }
        if (StringUtils.isBlank(this.visitUserName)) {
            throw new BusinessException("生成redishash失败，请指定拜访用户！");
        }
        if (StringUtils.isBlank(this.visitPosCode)) {
            throw new BusinessException("生成redishash失败，请指定拜访用户职位！");
        }
        StringJoiner joiner = new StringJoiner(RedisParam.DELIMITER);
        joiner.add(RedisParam.SFA_VISIT).add(SfaVisitPlanInfoEntity.TABLE_NAME).add(this.visitBigType)
                .add(this.visitUserName).add(this.visitPosCode).add(this.visitDate);
        return joiner;
    }

    /**
     * RedisHashKey 序列/反序列对象
     *
     * @author: luoqi
     * @Date: 2021-4-1 17:48
     * @version: V1.0
     * @Description:
     */
    public static class VisitRedisHash {
        private static final int visitBigType = 2;
        private static final int visitUserName = 3;
        private static final int visitPosCode = 4;
        private static final int visitDate = 5;

        private String redisHash;
        private String[] items;

        public VisitRedisHash(String redisHash) {
            this.redisHash = redisHash;
            this.resolveItems();
        }

        public VisitRedisHash(String visitDate, String visitUserName, String visitPosCode, String visitBigType) {
            if (StringUtils.isBlank(visitBigType)) {
                throw new BusinessException("生成redishash失败，请指定拜访大类！");
            }
            if (StringUtils.isBlank(visitDate)) {
                throw new BusinessException("生成redishash失败，请指定拜访日期！");
            }
            if (StringUtils.isBlank(visitUserName)) {
                throw new BusinessException("生成redishash失败，请指定拜访用户！");
            }
            if (StringUtils.isBlank(visitPosCode)) {
                throw new BusinessException("生成redishash失败，请指定拜访用户职位！");
            }
            StringJoiner joiner = new StringJoiner(RedisParam.DELIMITER);
            joiner.add(RedisParam.SFA_VISIT).add(SfaVisitPlanInfoEntity.TABLE_NAME).add(visitBigType)
                    .add(visitUserName).add(visitPosCode).add(visitDate);
            this.redisHash = joiner.toString();
            this.resolveItems();
        }

        private void resolveItems() {
            if (StringUtils.isBlank(this.redisHash)) {
                throw new BusinessException("redisHashKey 为空");
            }
            this.items = redisHash.split(RedisParam.DELIMITER);
            if (items.length != (visitDate + 1)) {
                throw new BusinessException("非法的 redisHash [" + this.redisHash + "]");
            }
        }

        public String getRedisHash() {
            return redisHash;
        }

        public String getVisitBigType() {
            return this.items[visitBigType];
        }

        public String getVisitUserName() {
            return this.items[visitUserName];
        }

        public String getVisitPosCode() {
            return this.items[visitPosCode];
        }

        public String getVisitDate() {
            return this.items[visitDate];
        }

    }

    @Getter(AccessLevel.NONE)
    @CrmColumn(name = "redis_hash_key")
    private String redisHashKey;


    /**
     * RedisHashKey 序列/反序列对象
     *
     * @author: luoqi
     * @Date: 2021-4-1 17:48
     * @version: V1.0
     * @Description:
     */
    public static class VisitRedisHashKey {
        public static final String DEF = "NONE";
        private static final int visitBigType = 2;
        private static final int visitUserName = 3;
        private static final int visitPosCode = 4;
        private static final int visitDate = 5;
        private static final int clientType = 6;
        private static final int clientCode = 7;

        private String redisHashKey;
        private String[] items;

        public VisitRedisHashKey(String redisHashKey) {
            this.redisHashKey = redisHashKey;
            this.resolveItems();
        }

        public VisitRedisHashKey(String visitDate, String visitUserName, String visitPosCode, String visitBigType
                , String clientType, String clientCode) {
            if (StringUtils.isBlank(visitUserName)) {
                throw new BusinessException("拜访用户不能为空！");
            }
            if (StringUtils.isBlank(visitPosCode)) {
                throw new BusinessException("拜访用户职位不能为空！");
            }
            if (StringUtils.isBlank(visitBigType)) {
                throw new BusinessException("拜访大类不能为空！");
            }
            if (StringUtils.isBlank(visitDate)) {
                throw new BusinessException("拜访日期不能为空！");
            }
            if (StringUtils.isBlank(clientType)) {
                throw new BusinessException("拜访网点类型不能为空！");
            }
            if (StringUtils.isBlank(clientCode)) {
                throw new BusinessException("拜访网点编码用户不能为空！");
            }
            StringJoiner joiner = new StringJoiner(RedisParam.DELIMITER);
            joiner.add(RedisParam.SFA_VISIT).add(SfaVisitPlanInfoEntity.TABLE_NAME).add(visitBigType)
                    .add(visitUserName).add(visitPosCode).add(visitDate)
                    .add(clientType).add(clientCode);
            this.redisHashKey = joiner.toString();
            this.resolveItems();
        }

        private void resolveItems() {
            if (StringUtils.isBlank(this.redisHashKey)) {
                throw new BusinessException("redisHashKey 为空");
            }
            this.items = redisHashKey.split(RedisParam.DELIMITER);
            if (items.length != (clientCode + 1)) {
                throw new BusinessException("非法的 redisHashKey [" + this.redisHashKey + "]");
            }
        }

        public String getRedisHashKey() {
            return redisHashKey;
        }

        public String getVisitBigType() {
            return this.items[visitBigType];
        }

        public String getVisitUserName() {
            return this.items[visitUserName];
        }

        public String getVisitPosCode() {
            return this.items[visitPosCode];
        }

        public String getVisitDate() {
            return this.items[visitDate];
        }

        public String getClientType() {
            return this.items[clientType];
        }

        public String getClientCode() {
            return this.items[clientCode];
        }
    }


    public String getRedisHashKey() {
        if (StringUtils.isBlank(this.getVisitUserName())) {
            throw new BusinessException("数据错误，拜访用户不能为空！");
        }
        if (StringUtils.isBlank(this.getVisitPosCode())) {
            throw new BusinessException("数据错误，拜访用户职位不能为空！");
        }
        if (StringUtils.isBlank(this.getVisitBigType())) {
            throw new BusinessException("数据错误，拜访大类不能为空！");
        }
        if (StringUtils.isBlank(this.getVisitDate())) {
            throw new BusinessException("数据错误，拜访日期不能为空！");
        }
        if (StringUtils.isBlank(this.getClientType())) {
            throw new BusinessException("数据错误，拜访网点类型不能为空！");
        }
        if (StringUtils.isBlank(this.getClientCode())) {
            throw new BusinessException("数据错误，拜访网点编码用户不能为空！");
        }
        StringJoiner joiner = new StringJoiner(RedisParam.DELIMITER);
        joiner.add(RedisParam.SFA_VISIT).add(SfaVisitPlanInfoEntity.TABLE_NAME).add(this.getVisitBigType())
                .add(this.getVisitUserName()).add(this.getVisitPosCode()).add(this.getVisitDate())
                .add(this.getClientType()).add(this.getClientCode());
        return joiner.toString();
    }

    public static void copyClientData(SfaVisitPlanInfoEntity planInfoEntity, SfaClientData clientData) {
        if (null == planInfoEntity || null == clientData) {
            return;
        }
        planInfoEntity.setClientCode(clientData.getClientCode());
        planInfoEntity.setClientName(clientData.getClientName());
        planInfoEntity.setClientType(clientData.getClientType());
        planInfoEntity.setClientTypeName(clientData.getClientTypeName());
        planInfoEntity.setClientContacts(clientData.getClientContacts());
        planInfoEntity.setClientPhoto(clientData.getClientPhoto());
        planInfoEntity.setClientSubclass(clientData.getClientSubclass());
        planInfoEntity.setClientSubclassName(clientData.getClientSubclassName());
        planInfoEntity.setClientAddress(clientData.getClientAddress());
        planInfoEntity.setClientPhone(clientData.getClientPhone());
        planInfoEntity.setLongitude(clientData.getLongitude());
        planInfoEntity.setLatitude(clientData.getLatitude());
    }

    /**
     * 组装写入redis缓存的数据
     *
     * @return
     */
    public Map<Object, Object> buildRedisDataForWrite() {
        Map<Object, Object> redisDataForWrite = Maps.newHashMap();
        redisDataForWrite.put(this.getRedisHashKey(), this);
        return redisDataForWrite;
    }

    public static final int countingCompletedNum(List<SfaVisitPlanInfoEntity> planInfoEntities) {
        int complete = 0;
        for (SfaVisitPlanInfoEntity planInfoEntity : planInfoEntities) {
            if (SfaVisitEnum.visitStatus.V3.getVal().equals(planInfoEntity.getVisitStatus())
                    || SfaVisitEnum.visitStatus.V4.getVal().equals(planInfoEntity.getVisitStatus())) {
                complete++;
            }
        }
        return complete;
    }


    /**
     * 拜访计划编码;拜访计划编码
     */
    @CrmColumn(name = "visit_plan_code", length = 32, note = "拜访计划编码/协访主键id")
    private String visitPlanCode;

    /**
     * 人员账号;人员账号
     */
    @CrmColumn(name = "visit_user_name", length = 32, note = "人员账号 人员账号")
    private String visitUserName;

    /**
     * 人员姓名;人员姓名
     */
    @CrmColumn(name = "visit_real_name", length = 100, note = "人员姓名 人员姓名")
    private String visitRealName;

    /**
     * 人员职位编码;人员职位编码
     */
    @CrmColumn(name = "visit_pos_code", length = 32, note = "人员职位编码 人员职位编码")
    private String visitPosCode;

    /**
     * 人员职位名称 人员职位名称
     */
    @CrmColumn(name = "visit_pos_name", length = 100, note = "人员职位名称 人员职位名称")
    private String visitPosName;

    /**
     * 人员所属组织编码;人员所属组织编码
     */
    @CrmColumn(name = "visit_org_code", length = 32, note = "人员所属组织编码 人员所属组织编码")
    private String visitOrgCode;

    /**
     * 人员所属组织名称 人员所属组织名称
     */
    @CrmColumn(name = "visit_org_name", length = 100, note = "人员所属组织名称 人员所属组织名称")
    private String visitOrgName;

    /**
     * 上级组织编码
     */
    @CrmColumn(name = "parent_org_code", length = 50, note = "上级组织编码")
    private String parentOrgCode;

    /**
     * 上级组织名称
     */
    @CrmColumn(name = "parent_org_name", length = 50, note = "上级组织名称")
    private String parentOrgName;

    /**
     * 数据类型(offline-离线,online-在线)
     */
    @CrmColumn(name = "line_status", length = 10, note = "数据类型(offline-离线,online-在线)")
    private String lineStatus;

    /**
     * 拜访日期;拜访日期yyyy-MM-dd
     */
    @CrmColumn(name = "visit_date", length = 16, note = "拜访日期;拜访日期yyyy-MM-dd")
    @Field(type = FieldType.Date, format = DateFormat.date)
    private String visitDate;

    @CrmColumn(name = "visit_date_of_year_month", length = 8, note = "拜访日期;拜访日期yyyy-MM")
    @Field(type = FieldType.Date, format = DateFormat.year_month)
    private String visitDateOfYearMonth;

    @CrmColumn(name = "visit_date_of_year", length = 4, note = "拜访日期;拜访日期yyyy")
    @Field(type = FieldType.Date, format = DateFormat.year)
    private String visitDateOfYear;

    /**
     * 拜访类型;拜访类型(临时拜访/计划拜访)
     */
    @CrmColumn(name = "visit_type", length = 32, note = "拜访类型;拜访类型(temporary:临时拜访/plan:计划拜访)")
    private String visitType;


    @CrmColumn(name = "visit_type_name", length = 32, note = "拜访类型;拜访类型(temporary:临时拜访/plan:计划拜访)")
    private String visitTypeName;


    /**
     * 拜访大类
     */
    @CrmColumn(name = "visit_big_type", length = 32, note = "拜访大类（VISIT:拜访，HELP_VISIT:协访，UNFAMILIAR_VISIT:陌拜）")
    @Field(type = FieldType.Keyword)
    private String visitBigType;

    /**
     * 拜访大类
     */
    @CrmColumn(name = "visit_big_type_name", length = 32, note = "拜访大类（VISIT:拜访，HELP_VISIT:协访）")
    private String visitBigTypeName;

    /**
     * 维度类型 维度类型（线路组、网点、频率	）
     */
    @CrmColumn(name = "route_type", length = 64, note = "维度类型 维度类型（线路组、网点、频率）")
    private String routeType;


    /**
     * 网点编码 协访网点编码
     */
    @CrmColumn(name = "client_code", length = 60, note = "网点编码 协访网点编码")
    private String clientCode;

    /**
     * 网点名称;协访网点名称
     */
    @CrmColumn(name = "client_name", length = 200, note = "网点名称 协访网点名称")
    private String clientName;


    /**
     * 网点类型;协访网点类型
     */
    @CrmColumn(name = "client_type", length = 32, note = "网点类型 协访网点类型")
    private String clientType;

    /**
     * 网点类型;协访网点类型
     */
    @CrmColumn(name = "client_type_name", length = 32, note = "网点类型 协访网点类型")
    private String clientTypeName;

    @CrmColumn(name = "client_subclass", length = 32, note = "客户细类")
    @Field(type = FieldType.Keyword)
    private String clientSubclass;

    @CrmColumn(name = "client_subclass_name", length = 32, note = "客户细类")
    private String clientSubclassName;
    /**
     * 网点类型 协访网点类型
     */
    @CrmColumn(name = "client_address", length = 512, note = "网点类型 协访网点类型")
    private String clientAddress;

    /**
     * 网点图片
     */
    @CrmColumn(name = "client_photo", length = 200, note = "网点图片")
    @Field(index = false, type = FieldType.Text)
    private String clientPhoto;

    /**
     * 网点联系人
     */
    @CrmColumn(name = "client_contacts", length = 200, note = "网点联系人")
    @Field(index = false, type = FieldType.Text)
    private String clientContacts;

    /**
     * 网点电话 网点电话
     */
    @CrmColumn(name = "client_phone", length = 32, note = "网点电话 网点电话")
    @Field(index = false, type = FieldType.Text)
    private String clientPhone;

    /**
     * 经度;协访网点经度
     */
    @CrmColumn(name = "longitude", mysqlType = "decimal(12,8)", oracleType = "NUMBER(12,8)", note = "客户经度")
    private BigDecimal longitude;

    /**
     * 纬度;协访网点纬度
     */
    @CrmColumn(name = "latitude", mysqlType = "decimal(12,8)", oracleType = "NUMBER(12,8)", note = "客户纬度")
    private BigDecimal latitude;

    @Getter(AccessLevel.NONE)
    @GeoPointField
    @Transient
    @TableField(exist = false)
    private String latitudeAndLongitude;

    public String getLatitudeAndLongitude() {
        if (null == longitude || null == latitude) {
            return null;
        }
        return new StringJoiner(",").add(latitude.toString()).add(longitude.toString()).toString();
    }

    /**
     * 状态;拜访状态
     */
    @CrmColumn(name = "visit_status", length = 32, note = "状态;拜访状态")
    private String visitStatus;

    @CrmColumn(name = "visit_status_name", length = 32, note = "状态;拜访状态")
    private String visitStatusName;


    /**
     * 被协访人员账号
     */
    @CrmColumn(name = "cover_help_user_name", length = 50, note = "被协访人员账号")
    private String coverHelpUserName;

    /**
     * 被协访人员姓名
     */
    @CrmColumn(name = "cover_help_real_name", length = 50, note = "被协访人员姓名")
    private String coverHelpRealName;

    /**
     * 被协访组织编码
     */
    @CrmColumn(name = "cover_help_org_code", length = 50, note = "被协访组织编码")
    private String coverHelpOrgCode;

    /**
     * 被协访组织名称
     */
    @CrmColumn(name = "cover_help_org_name", length = 50, note = "被协访组织名称")
    private String coverHelpOrgName;

    /**
     * 被协访职位编码
     */
    @CrmColumn(name = "cover_help_pos_code", length = 50, note = "被协访职位编码")
    private String coverHelpPosCode;

    /**
     * 被协访职位名称
     */
    @CrmColumn(name = "cover_help_pos_name", length = 50, note = "被协访职位名称")
    private String coverHelpPosName;

    /**
     * 计划拜访顺序
     */
    @CrmColumn(name = "visit_sort", mysqlType = "int(10)", oracleType = "NUMBER(10, 0)", note = "计划拜访顺序")
    @Field(type = FieldType.Keyword)
    private Integer visitSort;

}
