package com.biz.crm.visitinfo.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.base.CrmObjTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import com.biz.crm.util.JsonPropertyUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.AccessLevel;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.Mapping;

import javax.persistence.Index;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;


/**
 * 拜访计划明细执行数据-（原 SfaVisitDealerDetailEntity）
 *  @author: luoqi
 *  @Date: 2021-3-5 21:40
 *  @version: V1.0
 *  @Description:
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@CrmTable(name = "sfa_visit_plan_info_execute", tableNote = "拜访计划明细执行数据（原 SfaVisitDealerDetailEntity）", indexes = {
        @Index(name = "sfa_visit_plan_info_execute_index1", columnList = "visit_pos_code, visit_user_name, client_code, visit_org_code, visit_big_type"),
        @Index(name = "sfa_visit_plan_info_execute_index2", columnList = "visit_date"),
        @Index(name = "sfa_visit_plan_info_execute_index3", columnList = "visit_plan_info_id")})
@TableName("sfa_visit_plan_info_execute")
public class SfaVisitPlanInfoExecuteEntity extends CrmObjTenEntity<SfaVisitPlanInfoExecuteEntity> {
    /**
     * 拜访计划明细id;
     */
    @CrmColumn(name = "visit_plan_info_id", length = 32, note = "拜访计划明细id")
    private String visitPlanInfoId;
    /**
     * 拜访计划编码;
     */
    @CrmColumn(name = "visit_plan_code", length = 32, note = "拜访计划编码")
    private String visitPlanCode;


    /**
     * 人员账号;人员账号
     */
    @CrmColumn(name = "visit_user_name", length = 32, note = "人员账号")
    private String visitUserName;

    /**
     * 人员姓名;人员姓名
     */
    @CrmColumn(name = "visit_real_name", length = 32, note = "人员姓名")
    private String visitRealName;

    /**
     * 人员职位编码;人员职位编码
     */
    @CrmColumn(name = "visit_pos_code", length = 32, note = "人员职位编码")
    private String visitPosCode;

    /**
     * 人员职位名称;人员职位名称
     */
    @CrmColumn(name = "visit_pos_name", length = 32, note = "人员职位名称")
    private String visitPosName;

    /**
     * 人员所属组织编码;人员所属组织编码
     */
    @CrmColumn(name = "visit_org_code", length = 32, note = "人员所属组织编码")
    private String visitOrgCode;

    /**
     * 人员所属组织名称;人员所属组织名称
     */
    @CrmColumn(name = "visit_org_name", length = 32, note = "人员所属组织名称")
    private String visitOrgName;

    /**
     * 上级组织编码
     */
    @CrmColumn(name = "visit_parent_org_code", length = 32, note = "上级组织编码")
    private String visitParentOrgCode;

    /**
     * 上级组织名称
     */
    @CrmColumn(name = "visit_parent_org_name", length = 32, note = "上级组织名称")
    private String visitParentOrgName;

    /**
     * 拜访日期;拜访日期yyyy-MM-dd
     */
    @Field(type = FieldType.Date, format = DateFormat.date)
    @CrmColumn(name = "visit_date", length = 32, note = "拜访日期")
    private String visitDate;

    @CrmColumn(name = "visit_date_of_year_month", length = 8, note = "拜访日期;拜访日期yyyy-MM")
    @Field(type = FieldType.Date, format = DateFormat.year_month)
    private String visitDateOfYearMonth;

    @CrmColumn(name = "visit_date_of_year", length = 4, note = "拜访日期;拜访日期yyyy")
    @Field(type = FieldType.Date, format = DateFormat.year)
    private String visitDateOfYear;
    /**
     * 拜访类型;拜访类型(拜访类型;拜访类型(temporary:临时拜访/plan:计划拜访))
     */
    @CrmColumn(name = "visit_type", length = 32, note = "拜访类型(temporary:临时拜访/plan:计划拜访)")
    private String visitType;

    @CrmColumn(name = "visit_type_name", length = 32, note = "拜访类型(temporary:临时拜访/plan:计划拜访)")
    private String visitTypeName;

    /**
     * 拜访大类
     */
    @CrmColumn(name = "visit_big_type", length = 32, note = "拜访大类（VISIT:拜访，HELP_VISIT:协访）")
    @Field(type = FieldType.Keyword)
    private String visitBigType;

    /**
     * 拜访大类
     */
    @CrmColumn(name = "visit_big_type_name", length = 32, note = "拜访大类（VISIT:拜访，HELP_VISIT:协访）")
    private String visitBigTypeName;

    /**
     * 客户编码;
     */
    @CrmColumn(name = "client_code", length = 32, note = "客户编码")
    private String clientCode;

    /**
     * 客户名称;
     */
    @CrmColumn(name = "client_name", length = 32, note = "客户名称")
    private String clientName;

    /**
     * 客户类型;
     */
    @CrmColumn(name = "client_type", length = 32, note = "客户类型")
    private String clientType;

    /**
     * 客户类型;
     */
    @CrmColumn(name = "client_type_name", length = 32, note = "客户类型")
    private String clientTypeName;

    @CrmColumn(name = "client_subclass", length = 32, note = "客户细类")
    @Field(type = FieldType.Keyword)
    private String clientSubclass;

    @CrmColumn(name = "client_subclass_name", length = 32, note = "客户细类")
    private String clientSubclassName;

    /**
     * 客户电话
     */
    @CrmColumn(name = "client_phone", length = 16, note = "客户电话")
    private String clientPhone;
    /**
     * 网点图片
     */
    @CrmColumn(name = "client_photo", note = "网点图片")
    @Field(index = false,type = FieldType.Text)
    private String clientPhoto;


    /**
     * 客户地址;
     */
    @CrmColumn(name = "client_address", note = "客户地址")
    private String clientAddress;


    /**
     * 异常提交时间
     */
    @Mapping(mappingPath = "es-mapping/date-time.json")
    @CrmColumn(name = "exception_time", length = 32, note = "异常提交时间")
    private String exceptionTime;

    /**
     * 异常描述
     */
    @CrmColumn(name = "exception_detail", note = "异常描述")
    private String exceptionDetail;

    /**
     * 拜访总结
     */
    @CrmColumn(name = "visit_summary", note = "拜访总结")
    private String visitSummary;

    /**
     * 拜访汇总
     */
    @Transient
    @TableField(exist = false)
    private Map<String,String> visitDetailStep;

    @Getter(AccessLevel.NONE)
    @Setter(AccessLevel.NONE)
    @CrmColumn(name = "visit_detail_step_json", length = 512, note = "拜访汇总")
    private String visitDetailStepJson;

    public String getVisitDetailStepJson() {
        if(null == this.visitDetailStep){
            return null;
        }
        return JsonPropertyUtil.toJsonStringNotEmptyVal(this.visitDetailStep);
    }

    public void setVisitDetailStepJson(String visitDetailStepJson) {
        this.visitDetailStepJson = visitDetailStepJson;
        if(StringUtils.isBlank(visitDetailStepJson)){
            return;
        }
        this.visitDetailStep = JsonPropertyUtil.toObject(visitDetailStepJson, HashMap.class);
    }

    /**
     * 是否需要执行进店步骤 Y/N
     */
    @CrmColumn(name = "need_in_store_step", length = 8, note = "是否需要执行进店步骤 Y/N")
    private String needInStoreStep;

    /**
     * 进店时间
     */
    @Mapping(mappingPath = "es-mapping/date-time.json")
    @CrmColumn(name = "in_store", length = 32, note = "进店时间")
    private String inStore;

    /**
     * 进店地址
     */
    @CrmColumn(name = "in_store_address", note = "进店地址")
    private String inStoreAddress;

    /**
     * 进店经度
     */
    @CrmColumn(name = "in_store_longitude", length = 20, note = "进店经度")
    private BigDecimal inStoreLongitude;

    /**
     * 进店纬度
     */
    @CrmColumn(name = "in_store_latitude", length = 20, note = "进店纬度")
    private BigDecimal inStoreLatitude;

    /**
     * 是否需要执行离店步骤 Y/N
     */
    @CrmColumn(name = "need_out_store_step", length = 8, note = "是否需要执行离店步骤 Y/N")
    private String needOutStoreStep;

    /**
     * 离店时间
     */
    @Mapping(mappingPath = "es-mapping/date-time.json")
    @CrmColumn(name = "out_store", length = 32, note = "离店时间")
    private String outStore;

    /**
     * 离店地址
     */
    @CrmColumn(name = "out_store_address",  note = "离店地址")
    private String outStoreAddress;

    /**
     * 离店经度
     */
    @CrmColumn(name = "out_store_longitude", length = 20, note = "离店经度")
    private BigDecimal outStoreLongitude;

    /**
     * 离店纬度
     */
    @CrmColumn(name = "out_store_latitude", length = 20, note = "离店纬度")
    private BigDecimal outStoreLatitude;



    /**
     * 协访主键id
     */
    @CrmColumn(name = "help_Defense_Id", length = 32, note = "协访主键id")
    @Field(type = FieldType.Keyword)
    private String helpDefenseId;

    /**
     * 被协访人员账号
     */
    @CrmColumn(name = "cover_help_user_name", length = 50, note = "被协访人员账号")
    private String coverHelpUserName;

    /**
     * 被协访人员姓名
     */
    @CrmColumn(name = "cover_help_real_name", length = 50, note = "被协访人员姓名")
    private String coverHelpRealName;

    /**
     * 被协访组织编码
     */
    @CrmColumn(name = "cover_help_org_code", length = 50, note = "被协访组织编码")
    private String coverHelpOrgCode;

    /**
     * 被协访组织名称
     */
    @CrmColumn(name = "cover_help_org_name", length = 50, note = "被协访组织名称")
    private String coverHelpOrgName;

    /**
     * 被协访职位编码
     */
    @CrmColumn(name = "cover_help_pos_code", length = 50, note = "被协访职位编码")
    private String coverHelpPosCode;

    /**
     * 被协访职位名称
     */
    @CrmColumn(name = "cover_help_pos_name", length = 50, note = "被协访职位名称")
    private String coverHelpPosName;


    /**
     * 计划拜访顺序
     */
    @CrmColumn(name = "visit_sort", mysqlType = "int(10)" ,oracleType = "NUMBER(10, 0)",note = "计划拜访顺序")
    @Field(type = FieldType.Keyword)
    private Integer visitSort;



    @ApiModelProperty("拜访总结表单id")
    @Field(type = FieldType.Keyword)
    @CrmColumn(name = "form_id_as_summary", length = 50, note = "拜访总结表单id")
    private String formIdAsSummary;

    @ApiModelProperty("进店表单id")
    @Field(type = FieldType.Keyword)
    @CrmColumn(name = "form_id_as_in_store", length = 50, note = "进店表单id")
    private String formIdAsInStore;

    @ApiModelProperty("离店表单id")
    @Field(type = FieldType.Keyword)
    @CrmColumn(name = "form_id_as_out_store", length = 50, note = "离店表单id")
    private String formIdAsOutStore;

}
