package com.biz.crm.visitinfo.model;

import com.biz.crm.base.CrmAttachment;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.util.List;


/**
 * 拜访计划明细执行数据-（原 SfaVisitDealerDetailEntity）
 *  @author: luoqi
 *  @Date: 2021-3-8 12:12
 *  @version: V1.0
 *  @Description:
 */
@Data
public class SfaVisitPlanInfoExecuteRedisData extends SfaVisitPlanInfoExecuteEntity {

    @ApiModelProperty("拜访总结表单配置")
    private SfaVisitStepFromRespVo sfaVisitStepFromAsSummary;

    @ApiModelProperty("进店表单配置")
    private SfaVisitStepFromRespVo sfaVisitStepFromAsInStore;

    @ApiModelProperty("离店表单配置")
    private SfaVisitStepFromRespVo sfaVisitStepFromAsOutStore;
    //进店照片
    @ApiModelProperty("进店照片")
    private List<CrmAttachment> visitInPics;
    //离店照片
    @ApiModelProperty("离店照片")
    private List<CrmAttachment> visitOutPics;

    //异常照片
    @ApiModelProperty("异常照片")
    private List<CrmAttachment> visitExceptionPics;

}
