package com.biz.crm.visitinfo.req;

import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.mdm.ExtTenVo;
import com.biz.crm.sqlupdate.CrmColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;

import java.util.List;

@Data
@ApiModel("查询拜访计划明细分页-参数")
public class GetVisitReportsPageReq extends ExtTenVo {

    @ApiModelProperty("拜访大类（VISIT:拜访，HELP_VISIT:协访，UNFAMILIAR_VISIT:陌拜）")
    private String visitBigType;
    @ApiModelProperty("拜访计划类型")
    private String visitType;
    @ApiModelProperty("用户名称")
    private String visitRealName;

    @ApiModelProperty("拜访状态")
    protected String visitStatus;

    @ApiModelProperty("职位名称")
    private String visitPosName;

    @ApiModelProperty("组织名称")
    private String visitOrgName;

    @ApiModelProperty("组织编码")
    private String visitOrgCode;

    @ApiModelProperty("客户类型")
    private String clientType;

    @ApiModelProperty("客户编码")
    private String clientCode;

    @ApiModelProperty("客户名称")
    private String clientName;

    @ApiModelProperty("拜访开始时间")
    private String endVisitDate;

    @ApiModelProperty("拜访结束时间")
    private String startVisitDate;

    @ApiModelProperty("提交时间-开始")
    private String outStoreStartTime;

    @ApiModelProperty("提交时间-结束")
    private String outStoreEndTime;

    @ApiModelProperty("年月")
    private String yearMonth;


    /**
     * 被协访人员账号
     */
    @ApiModelProperty("被协访人员账号")
    private String coverHelpUserName;

    /**
     * 被协访人员姓名
     */
    @ApiModelProperty("被协访人员姓名")
    private String coverHelpRealName;

    /**
     * 被协访组织编码
     */
    @ApiModelProperty("被协访组织编码")
    private String coverHelpOrgCode;

    /**
     * 被协访组织名称
     */
    @ApiModelProperty("被协访组织名称")
    private String coverHelpOrgName;

    /**
     * 被协访职位编码
     */
    @ApiModelProperty("被协访职位编码")
    private String coverHelpPosCode;

    /**
     * 被协访职位名称
     */
    @ApiModelProperty("被协访职位名称")
    private String coverHelpPosName;


    @ApiModelProperty("页码")
    private Integer pageNum = 1;

    @ApiModelProperty("每页长度")
    private Integer pageSize = 15;

    /**
     *
     * @return
     */
    public NativeSearchQuery buildQuery(List<QueryBuilder> queryBuilderExtend){
        if(StringUtils.isBlank(this.getVisitBigType())){
            throw new BusinessException("请指定拜访大类");
        }
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        builder.must(QueryBuilders.termsQuery("visitBigType", this.getVisitBigType().split(",")));
        if(StringUtils.isNotBlank(this.getClientType())){
            builder.must(QueryBuilders.termQuery("clientType.keyword", this.getClientType()));
        }
        if(null != queryBuilderExtend){
            for (QueryBuilder queryBuilder : queryBuilderExtend) {
                if(null == queryBuilder){
                    builder.must(queryBuilder);
                }
            }
        }
        if(StringUtils.isNotBlank(this.getVisitType())){
            builder.must(QueryBuilders.termQuery("visitType.keyword", this.getVisitType()));
        }
        if(StringUtils.isNotBlank(this.getVisitStatus())){
            builder.must(QueryBuilders.termQuery("visitStatus.keyword", this.getVisitStatus()));
        }
        //设置模糊搜索
        if(StringUtils.isNotBlank(this.getClientCode())){
            builder.must(QueryBuilders.wildcardQuery("clientCode.keyword", "*" + this.getClientCode() + "*"));
        }

        //设置模糊搜索
        if(StringUtils.isNotBlank(this.getVisitOrgName())){
            builder.must(QueryBuilders.wildcardQuery("visitOrgName.keyword", "*" + this.getVisitOrgName() + "*"));
        }
        //设置模糊搜索
        if(StringUtils.isNotBlank(this.getVisitOrgCode())){
            builder.must(QueryBuilders.wildcardQuery("visitOrgCode.keyword", "*" + this.getVisitOrgCode() + "*"));
        }

        if(StringUtils.isNotBlank(this.getVisitRealName())){
            builder.must(QueryBuilders.wildcardQuery("visitRealName.keyword", "*" + this.getVisitRealName() + "*"));
        }
        if(StringUtils.isNotBlank(this.getVisitPosName())){
            builder.must(QueryBuilders.wildcardQuery("visitPosName.keyword", "*" + this.getVisitPosName() + "*"));
        }
        if(StringUtils.isNotBlank(this.getClientName())){
            builder.must(QueryBuilders.wildcardQuery("clientName.keyword", "*" + this.getClientName() + "*"));
        }
        if(StringUtils.isNotBlank(this.getStartVisitDate())){
            builder.must(QueryBuilders.rangeQuery("visitDate").from(this.getStartVisitDate()));
        }
        if(StringUtils.isNotBlank(this.getEndVisitDate())){
            builder.must(QueryBuilders.rangeQuery("visitDate").to(this.getEndVisitDate()));
        }

        RangeQueryBuilder rangeQueryBuilder = null;
        if(StringUtils.isNotBlank(this.getOutStoreStartTime())){
            rangeQueryBuilder = QueryBuilders.rangeQuery("sfaVisitPlanInfoExecuteRedisData.outStore")
                    .gte(this.getOutStoreStartTime());
        }
        if(StringUtils.isNotBlank(this.getOutStoreEndTime())){
            if(null == rangeQueryBuilder){
                rangeQueryBuilder = QueryBuilders.rangeQuery("sfaVisitPlanInfoExecuteRedisData.outStore")
                        .lte(this.getOutStoreEndTime());
            }else{
                rangeQueryBuilder.lte(this.getOutStoreEndTime());
            }
        }
        if(null != rangeQueryBuilder){
            builder.must(rangeQueryBuilder);
        }

        //构建查询
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        //将搜索条件设置到构建中
        nativeSearchQueryBuilder.withQuery(builder);
        //设置分页
        //====注意!es的分页和Hibernate一样api是从第0页开始的=========
        nativeSearchQueryBuilder.withPageable(PageRequest.of(this.getPageNum() - 1, this.getPageSize()));
        //排序
        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort("visitDate").order(SortOrder.DESC));
        //生产NativeSearchQuery
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        return query;
    }
}
