package com.biz.crm.visitinfo.req;

import com.biz.crm.nebular.mdm.position.resp.MdmPositionPageRespVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
@ApiModel("结算给定日期的拜访计划明细")
public class PlanInfoSettlementReq {

    @ApiModelProperty("用户")
    private String visitUserName;

    @ApiModelProperty("用户职位编码")
    private String visitPositionCode;

    @ApiModelProperty("拜访日期yyyy-MM-dd")
    private String visitDate;

    @ApiModelProperty("需要解析的拜访明细数据的用户信息")
    private List<VisitUserPosition> visitUserPositionList;


    @Data
    @ApiModel("拜访用户职位")
    public static class VisitUserPosition{

        @ApiModelProperty("职位编码")
        private String visitPositionCode;

        @ApiModelProperty("用户")
        private String visitUserName;
    }

}
