package com.biz.crm.visitinfo.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.visitinfo.model.SfaVisitCompleteInfoEntity;
import com.biz.crm.visitinfo.req.VisitCompleteInfoSearchReqVo;
import com.biz.crm.visitinfo.resp.report.SfaVisitCompleteInfoRespVo;
import com.biz.crm.visitinfo.resp.report.SfaVisitRouteRespVo;

/**
 * 拜访完成报表
 * @author YuanZiJian
 * @date 2021/3/26 17:00
 * @version: V1.0
 */
public interface ISfaVisitCompleteInfoService extends IService<SfaVisitCompleteInfoEntity> {
    /**
     * 后台——拜访完成报表——获取每日的完成报表进度
     * @method getVisitCompleteInfoList
     * @date: 2021/3/26 17:12
     * @author: YuanZiJian
     * @param visitCompleteInfoSearchReqVo 查询条件
     * @return com.biz.crm.common.PageResult<com.biz.crm.visitinfo.resp.report.SfaVisitCompleteInfoRespVo>
     */
    PageResult<SfaVisitCompleteInfoRespVo> getVisitCompleteInfoDailyList(VisitCompleteInfoSearchReqVo visitCompleteInfoSearchReqVo);

    /**
     * 后台——拜访完成报表——获取每月的完成报表进度
     * @method getVisitCompleteInfoMonthList
     * @date: 2021/3/26 17:46
     * @author: YuanZiJian
     * @param visitCompleteInfoSearchReqVo
     * @return com.biz.crm.common.PageResult<com.biz.crm.visitinfo.resp.report.SfaVisitCompleteInfoRespVo>
     */
    PageResult<SfaVisitCompleteInfoRespVo> getVisitCompleteInfoMonthList(VisitCompleteInfoSearchReqVo visitCompleteInfoSearchReqVo);

    void planInfoSettlementForWeb(String visitDateTemp);
    void planInfoSettlementForJob(String visitDateTemp);
    /**
     * 拜访完成进度报表日进度详情
     * @method dailyCompleteInfo
     * @date: 2021/3/29 16:16
     * @author: YuanZiJian
     * @param date
     * @param posName
     * @return void
     */
    Result<SfaVisitRouteRespVo> dailyCompleteInfo(String date , String posName);

    void brushVisitCompleteInfo();
}
