package com.biz.crm.visitinfo.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.collection.controller.resp.VisitStepResp;
import com.biz.crm.visitinfo.model.SfaVisitInfoStepFormEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;

import java.util.List;

/**
 * 拜访明细步骤表单接口
 *
 * @author lf
 * @date 2021-07-18 15:00:34
 */
public interface ISfaVisitInfoStepFormService extends IService<SfaVisitInfoStepFormEntity> {

    /**
     * 保存当前拜访明细的拜访步骤
     * @param list
     */
    void saveSfaVisitInfoForm(List<VisitStepResp> list, SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity);

    /**
     * 更新拜访步骤状态
     * @param stepCode
     * @param visitPlanInfoId
     */
    void updateVisitStepStatus(String stepCode,String visitPlanInfoId);

    /**
     * 解析拜访明细数据的拜访步骤
     * @param visitDate
     */
    void resolvingVisitPlanInfoStepForm(String visitDate);
}

