package com.biz.crm.visitinfo.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.moblie.controller.visit.req.GetVisitListReq;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitResp;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitAndSalesTrendChartRespVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitRankingRespVo;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import com.biz.crm.visitinfo.req.VisitAndSalesReq;

import java.util.List;

/**
 * 拜访计划;接口
 *
 * @author Xiao
 * @date 2020-09-30 10:26:35
 */
public interface ISfaVisitPlanInfoService extends IService<SfaVisitPlanInfoEntity> {

    /**
     * 修改步骤状态
     * @param visitPlanInfoId
     * @param visitStepCode
     */
    void updateStepStatus(String visitPlanInfoId, SfaCodeEnum.VisitStepCode visitStepCode);
    /**
     * 更新步骤状态
     *  @author: luoqi
     *  @Date: 2021-3-5 22:29
     *  @version: V1.0
     *  @Description:
     */
    void updateStepStatus(String redisHashKey, String stepCode, String visitBigType);

    /**
     * 修改步骤执行状态
     * @param sfaVisitPlanInfoRedisData 拜访计划明细执行数据
     * @param stepCode 步骤编码
     */
    void changeStepStatus(SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData, String stepCode);
    /**
     * 查询用户指定日期的拜访列表
     * @param reqVo
     * @return
     */
    SfaVisitResp getVisitInfoList(GetVisitListReq reqVo);

    /**
     * 查询用户指定日期的拜访列表
     * @param req
     * @return
     */
    List<SfaVisitPlanInfoEntity> doGetVisitInfoList(GetVisitListReq req);

    List<SfaVisitPlanInfoEntity> getVisitInfoListByClientType(GetVisitListReq.MoreReq req);


    /**
     * 查询
     * @param sfaVisitPlanInfoReqVo
     * @return SfaVisitPlanInfoRespVo
     */
    SfaVisitPlanInfoRespVo query(SfaVisitPlanInfoReqVo sfaVisitPlanInfoReqVo);


    String checkAddForTempPlan(List<SfaVisitPlanInfoEntity> infoEntities);

    /**
     * 拜访数据持久化
     * @param sfaVisitPlanInfoEntity
     * @param sfaVisitPlanInfoRedisData
     */
    void dataDurability(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData);
    /**
     * 更新
     * @param sfaVisitPlanInfoEntity
     * @return
     */
    void saveOrUpdate(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, SfaVisitPlanInfoRedisData sfaVisitPlanInfoRedisData);

    /**
     * 更新
     * @param sfaVisitPlanInfoReqVo
     * @return
     */
    void update(SfaVisitPlanInfoReqVo sfaVisitPlanInfoReqVo);

    /**
     * 删除
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);

    /**
     * 拜访与销售走势图
     * @param userName
     * @return
     */
    List<SfaVisitAndSalesTrendChartRespVo> findVisiAndSalesTrendChart(VisitAndSalesReq req);

    /**
     * 近段时间拜访排行
     * @return
     */
    SfaVisitRankingRespVo findVisitRankingList();

    /**
     * 解析拜访明细数据执行数据关联
     */
    void updateVisitPlanInfo();

    String checkForTempPlan(List<SfaVisitPlanInfoEntity> planInfoEntities);
}

