package com.biz.crm.visitinfo.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.collection.controller.resp.VisitStepResp;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoExecuteRedisData;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import com.biz.crm.visitinfo.resp.report.VisitInfoReportResp;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.visitinfo.service.impl
 * @date 2021/7/17 16:27
 */
@Component
public class SfaVisitPlanInfoReportHelper {


    /**
     * 组装拜访详情
     *
     * @author: luoqi
     * @Date: 2021-3-21 14:31
     * @version: V1.0
     * @Description:
     */
    public void buildVisitInfoReport(SfaVisitPlanInfoRedisData planInfoRedisData, VisitInfoReportResp reportVo) {


        reportVo.setVisitStatus(planInfoRedisData.getVisitStatus());
        reportVo.setVisitStatusName(planInfoRedisData.getVisitStatusName());
        CrmBeanUtil.copyPropertiesIgnoreEmpty(planInfoRedisData, reportVo);
        Map<String, String> visitDetailStepMap = JSONObject.parseObject(reportVo.getVisitDetailStepJson(), Map.class);
        reportVo.setVisitDetailStep(visitDetailStepMap);
        reportVo.setStep(this.buildSteps(planInfoRedisData, false));
    }

    private List<VisitStepResp> buildSteps(SfaVisitPlanInfoRedisData planInfoRedisData, boolean summary) {
        List<VisitStepResp> stepTemp = planInfoRedisData.getStep();
        SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData = planInfoRedisData.getSfaVisitPlanInfoExecuteRedisData();
        List<VisitStepResp> steps = Lists.newArrayList();
        VisitStepResp inStep = this.buildInStore(sfaVisitPlanInfoExecuteRedisData);
        VisitStepResp outStep = this.buildOutStore(sfaVisitPlanInfoExecuteRedisData);
        if (null != inStep) {
            //进店
            steps.add(inStep);
        }
        //业务步骤
        if (null != stepTemp) {
            for (VisitStepResp stepResp : stepTemp) {
                if (!summary && SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_SUMMARY.getVal().equals(stepResp.getStepCode())) {
                    continue;
                }
                VisitStepResp temp = VisitStepResp.build(stepResp);
                if (SfaCodeEnum.VisitStepCode.SFA_STEP_CODE_SUMMARY.getVal().equals(stepResp.getStepCode())) {
                    VisitStepResp.SummaryData summaryData = new VisitStepResp.SummaryData();
                    summaryData.setSfaVisitStepFrom(sfaVisitPlanInfoExecuteRedisData.getSfaVisitStepFromAsSummary());
                    summaryData.setVisitDetailStep(sfaVisitPlanInfoExecuteRedisData.getVisitDetailStep());
                    summaryData.setVisitSummary(sfaVisitPlanInfoExecuteRedisData.getVisitSummary());
                    temp.setData(summaryData);
                }

                steps.add(temp);
            }
        }

        if (null != outStep) {
            //离店
            steps.add(outStep);
        }
        return steps;
    }


    /**
     * 进店
     *
     * @param sfaVisitPlanInfoExecuteRedisData
     * @return
     */
    private VisitStepResp buildInStore(SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData) {
        if (YesNoEnum.yesNoEnum.YES.getValue().equals(sfaVisitPlanInfoExecuteRedisData.getNeedInStoreStep())) {
            //执行步骤
            VisitStepResp.InOutData inData = new VisitStepResp.InOutData();
            CrmBeanUtil.copyExt10(sfaVisitPlanInfoExecuteRedisData, inData);
            SfaVisitStepFromRespVo sfaVisitStepFromAsInStore = sfaVisitPlanInfoExecuteRedisData.getSfaVisitStepFromAsInStore();
            inData.setSfaVisitStepFrom(sfaVisitStepFromAsInStore);
            inData.setStoreAddress(sfaVisitPlanInfoExecuteRedisData.getInStoreAddress());
            inData.setStoreDateTime(sfaVisitPlanInfoExecuteRedisData.getInStore());
            inData.setStoreLatitude(sfaVisitPlanInfoExecuteRedisData.getInStoreLatitude());
            inData.setStoreLongitude(sfaVisitPlanInfoExecuteRedisData.getInStoreLongitude());
            inData.setStorePics(sfaVisitPlanInfoExecuteRedisData.getVisitInPics());
            VisitStepResp inStep = VisitStepResp.build(SfaVisitEnum.visitStep.VISIT_STEP_IN_STORE.getDesc(), SfaVisitEnum.visitStep.VISIT_STEP_IN_STORE.getVal(), null, inData);
            inStep.setIsSuccess(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getVal());
            inStep.setIsSuccessDesc(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getDesc());
            if (null != sfaVisitStepFromAsInStore) {
                inStep.setIcon(sfaVisitStepFromAsInStore.getIcon());
            }
            return inStep;
        }
        return null;
    }

    /**
     * 离店
     *
     * @param sfaVisitPlanInfoExecuteRedisData
     * @return
     */
    private VisitStepResp buildOutStore(SfaVisitPlanInfoExecuteRedisData sfaVisitPlanInfoExecuteRedisData) {
        if (YesNoEnum.yesNoEnum.YES.getValue().equals(sfaVisitPlanInfoExecuteRedisData.getNeedOutStoreStep())) {
            //执行步骤
            VisitStepResp.InOutData outData = new VisitStepResp.InOutData();
            CrmBeanUtil.copyExt10(sfaVisitPlanInfoExecuteRedisData, outData);
            SfaVisitStepFromRespVo sfaVisitStepFromAsOutStore = sfaVisitPlanInfoExecuteRedisData.getSfaVisitStepFromAsOutStore();
            outData.setSfaVisitStepFrom(sfaVisitStepFromAsOutStore);
            outData.setStoreAddress(sfaVisitPlanInfoExecuteRedisData.getOutStoreAddress());
            outData.setStoreDateTime(sfaVisitPlanInfoExecuteRedisData.getOutStore());
            outData.setStoreLatitude(sfaVisitPlanInfoExecuteRedisData.getOutStoreLatitude());
            outData.setStoreLongitude(sfaVisitPlanInfoExecuteRedisData.getOutStoreLongitude());
            outData.setStorePics(sfaVisitPlanInfoExecuteRedisData.getVisitOutPics());
            VisitStepResp outStep = VisitStepResp.build(SfaVisitEnum.visitStep.VISIT_STEP_OUT_STORE.getDesc(), SfaVisitEnum.visitStep.VISIT_STEP_OUT_STORE.getVal(), null, outData);
            outStep.setIsSuccess(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getVal());
            outStep.setIsSuccessDesc(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getDesc());
            if (null != sfaVisitStepFromAsOutStore) {
                outStep.setIcon(sfaVisitStepFromAsOutStore.getIcon());
            }
            return outStep;
        }
        return null;
    }


    /**
     * 添加拜访步骤-拜访总结
     * @param planInfoRedisData
     * @param reportVo
     * @param summary
     */
    public void buildVisitInfoReport(SfaVisitPlanInfoRedisData planInfoRedisData, VisitInfoReportResp reportVo,boolean summary) {
        reportVo.setVisitStatus(planInfoRedisData.getVisitStatus());
        reportVo.setVisitStatusName(planInfoRedisData.getVisitStatusName());
        CrmBeanUtil.copyPropertiesIgnoreEmpty(planInfoRedisData, reportVo);
        Map<String, String> visitDetailStepMap = (Map)JSONObject.parseObject(reportVo.getVisitDetailStepJson(), Map.class);
        reportVo.setVisitDetailStep(visitDetailStepMap);
        reportVo.setStep(this.buildSteps(planInfoRedisData, summary));
    }

}
