package com.biz.crm.visitinfo.stepformcomponent;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.common.param.RedisParam;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoStepFormRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoExecuteEntity;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoRedisData;
import com.biz.crm.visitinfo.repositories.SfaVisitPlanInfoRedisDataRepositories;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoExecuteService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collector;
import java.util.stream.Collectors;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.visitinfo.stepformcomponent
 * @date 2021/7/19 11:14
 */
@Component
@ConditionalOnMissingBean(name = "SfaVisitPlanInfoStepFormComponentExpandImpl")
@Slf4j
public class SfaVisitPlanInfoStepFormComponent {

    //核心线程数
    private static final Integer CORE_POOL_SIZE = 30;

    //临时线程数
    private static final Integer MAXIMUM_POOL_SIZE = 50;

    //空闲时间清除临时线程数
    private static final Integer KEEP_ALIVE_TIME = 50;

    private static final Integer SIZE = 2000;

    /**
     * 使用无解的队列方式，避免导致使用人数过多，加载数据失败
     */
    private static final LinkedBlockingQueue<Runnable> QUEUE = new LinkedBlockingQueue<>(SIZE);

    private ThreadPoolExecutor THREAD_POOL_EXECUTOR = new ThreadPoolExecutor(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, KEEP_ALIVE_TIME, TimeUnit.SECONDS, QUEUE);

    @Resource
    private SfaVisitPlanInfoRedisDataRepositories sfaVisitPlanInfoRedisDataRepositories;
    @Resource
    private ISfaVisitPlanInfoExecuteService sfaVisitPlanInfoExecuteService;

    /**
     * 解析拜访明细数据表单
     *
     * @param list
     */
    public void resolvingStepForm(List<SfaVisitPlanInfoStepFormRespVo> list) {
        THREAD_POOL_EXECUTOR.execute(() -> {
            list.forEach(l -> {
                List<String> stepSuccessStatus = l.getStepSuccessStatusList();
                stepSuccessStatus.forEach(step -> {
                    VisitPlanInfoStepFormValidator validator = new VisitPlanInfoStepFormValidator(step);
                    validator.resolvingVisitPlanInfoStepForm(l);
                });
            });
        });

    }


    /**
     * 从es获取拜访步骤
     *
     * @param list
     * @return
     */
    public List<SfaVisitPlanInfoStepFormRespVo> getVisitPlanInfoRedisDataByEs(List<SfaVisitPlanInfoStepFormRespVo> list) {
        List<SfaVisitPlanInfoStepFormRespVo> dataList = list.stream().map(data -> {
            SfaVisitPlanInfoStepFormRespVo respVo = new SfaVisitPlanInfoStepFormRespVo();
            Optional<SfaVisitPlanInfoRedisData> optional = sfaVisitPlanInfoRedisDataRepositories.findById(data.getVisitPlanInfoId());
            if (optional.isPresent()) {
                SfaVisitPlanInfoRedisData redisData = optional.get();
                if (CollectionUtil.listNotEmptyNotSizeZero(redisData.getStep())) {
                    respVo = CrmBeanUtil.copy(data, SfaVisitPlanInfoStepFormRespVo.class);
                    List<String> stepList = redisData.getStep().stream()
                            .map(x -> {
                                StringJoiner step = new StringJoiner(RedisParam.DELIMITER);
                                step.add(x.getStepCode()).add(x.getIsSuccess())
                                        .add(x.getStepName()).add(x.getFormId())
                                        .add(x.getSort().toString());
                                return step.toString();
                            }).collect(Collectors.toList());
                    log.warn("从es取出的拜访步骤列表:{}", JSONObject.toJSONString(stepList));
                    respVo.setStepSuccessStatusList(stepList);
                }
            }
            return respVo;
        }).filter(x -> x != null && CollectionUtil.listNotEmptyNotSizeZero(x.getStepSuccessStatusList())).collect(Collectors.toList());
        return dataList;
    }


}