package com.biz.crm.visitinfo.stepformcomponent;

import com.biz.crm.common.param.RedisParam;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.moblie.visitoffline.SfaVisitStepConstant;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoStepFormRespVo;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.visitinfo.stepformcomponent
 * @date 2021/7/19 15:27
 */
public class VisitPlanInfoStepFormValidator {

    private VisitPlanInfoStepFormStrategy strategy;

    public VisitPlanInfoStepFormValidator(String step) {
        String[] stepSuccess = step.split(RedisParam.DELIMITER);
        strategy = SpringApplicationContextUtil.getApplicationContext().getBean(stepSuccess[0] + SfaVisitStepConstant.STEP_FORM_BEAN, VisitPlanInfoStepFormStrategy.class);
        strategy.setStepCode(stepSuccess[0]);
        strategy.setStepSuccess(stepSuccess[1]);
        strategy.setStepName(stepSuccess[2]);
        strategy.setFormId(stepSuccess[3]);
        strategy.setSort(Integer.valueOf(stepSuccess[4]));
    }

    /**
     * 解析拜访明细步骤数据
     *
     * @param respVo
     */
    public void resolvingVisitPlanInfoStepForm(SfaVisitPlanInfoStepFormRespVo respVo) {
        strategy.resolvingVisitPlanInfoStepForm(respVo);
    }
}
