package com.biz.crm.visitnote.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.visitnote.service.ISfaVisitclientRelService;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitclientRelRespVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitclientRelReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.List;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 线路组对应客户信息 
 *
 * @author liuhongming
 * @date 2020-09-18 16:53:00
 */
@Slf4j
@RestController
@RequestMapping("/sfaVisitclientRelController")
@Api(tags = "线路组对应客户信息 ")
public class SfaVisitclientRelController {
    @Autowired
    private ISfaVisitclientRelService sfaVisitclientRelService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaVisitclientRelRespVo>> list(@RequestBody SfaVisitclientRelReqVo sfaVisitclientRelReqVo) {
        PageResult<SfaVisitclientRelRespVo> result=sfaVisitclientRelService.findList(sfaVisitclientRelReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaVisitclientRelRespVo> query(@RequestBody SfaVisitclientRelReqVo sfaVisitclientRelReqVo) {
        SfaVisitclientRelRespVo respVo=sfaVisitclientRelService.query(sfaVisitclientRelReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaVisitclientRelReqVo sfaVisitclientRelReqVo) {
        sfaVisitclientRelService.save(sfaVisitclientRelReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaVisitclientRelReqVo sfaVisitclientRelReqVo) {
        sfaVisitclientRelService.update(sfaVisitclientRelReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        sfaVisitclientRelService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        sfaVisitclientRelService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        sfaVisitclientRelService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
