package com.biz.crm.visitnote.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitAssitPlanReqVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitPlanReqVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitTempPlanReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitAssitPlanRespVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitPlanRespVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitTempPlanRespVo;
import com.biz.crm.visitnote.model.SfaVisitPlanEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 拜访计划制定 
 * 
 * @author liuhongming
 * @date 2020-09-21 14:35:05
 */
public interface SfaVisitPlanMapper extends BaseMapper<SfaVisitPlanEntity> {
    /**
     * 列表
     * @param page
     * @param sfaVisitPlanReqVo
     * @return
     */
    @SqlPrivilege(orgCode = "sfa_visit_plan.visit_org_code",posCode = "sfa_visit_plan.visit_pos_code")
    List<SfaVisitPlanRespVo> findList(Page<SfaVisitPlanRespVo> page, @Param("vo") SfaVisitPlanReqVo sfaVisitPlanReqVo);

    /**
     * 删除
     * @param sfaVisitPlanReqVo
     */
    void deleteProductsByParams(@Param("vo") SfaVisitPlanReqVo sfaVisitPlanReqVo);

    List<SfaVisitPlanEntity> findListForJob(@Param("visitPosCode")List<String> visitPosCode, @Param("now")String now, @Param("future")String future);
    /**
     * 临时计划列表
     * @param page
     * @param sfaVisitPlanReqVo
     * @return
     */
    List<SfaVisitTempPlanRespVo> findTempList(Page<SfaVisitTempPlanRespVo> page, @Param("vo") SfaVisitTempPlanReqVo sfaVisitPlanReqVo);

    /**
     * 删除临时计划
     * @param sfaVisitPlanReqVo
     */
    void deleteProductsByParamsTemp(@Param("vo") SfaVisitTempPlanReqVo sfaVisitPlanReqVo);

    /**
     * 协防计划制定列表
     * @param page
     * @param sfaVisitPlanReqVo
     * @return
     */
    List<SfaVisitAssitPlanRespVo> findAssitList(Page<SfaVisitAssitPlanRespVo> page, @Param("vo") SfaVisitAssitPlanReqVo sfaVisitPlanReqVo);

    /**
     * 删除协防计划制定
     * @param sfaVisitPlanReqVo
     */
    void deleteProductsByParamsAssit(@Param("vo") SfaVisitAssitPlanReqVo sfaVisitPlanReqVo);

    /**
     * 通过条件查询拜访计划
     * @return
     */
    List<SfaVisitPlanRespVo> findSfaVisitPlanRespVoListByCondition(@Param("vo") SfaVisitPlanInfoReqVo reqVo);

    /**
     * 查询线路组是否存在拜访计划中
     * @return
     */
    Integer findSfaVisitPlanGroupCount(@Param("vo") SfaVisitPlanReqVo sfaVisitPlanReqVo);

    /**
     * 查询拜访次数
     */
    List<SfaVisitPlanRespVo> getVisitNum(@Param("firstDay")String firstDay,@Param("lastDay")String lastDay,@Param("createDate")String createDate);
}
