package com.biz.crm.visitnote.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 拜访计划制定范围表 实体类
 *
 * @author liuhongming
 * @date 2020-09-21 14:35:05
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_visit_plan_range")
@CrmTable(name = "sfa_visit_plan_range", tableNote = "拜访计划制定范围表")
public class SfaVisitPlanRangeEntity extends CrmExtTenEntity<SfaVisitPlanRangeEntity> {

    /**
     * 线路组id 线路组id
     */
    @CrmColumn(name = "visit_group_id", length = 32, note = "线路组id 线路组id")
    private String visitGroupId;

    /**
     * 线路组名称 线路组名称
     */
    @CrmColumn(name = "visit_group_name", length = 100, note = "线路组名称 线路组名称")
    private String visitGroupName;

    /**
     * 网点id 网点id
     */
    @CrmColumn(name = "client_id", length = 64, note = "网点id 网点id")
    private String clientId;

    /**
     * 网点编码 网点编码
     */
    @CrmColumn(name = "client_code", length = 32, note = "网点编码 网点编码")
    private String clientCode;

    /**
     * 网点名称 网点名称
     */
    @CrmColumn(name = "client_name", length = 100, note = "网点名称 网点名称")
    private String clientName;

    /**
     * 网点类型 网点类型
     */
    @CrmColumn(name = "client_type", length = 32, note = "网点类型 网点类型")
    private String clientType;
    @CrmColumn(name = "client_type_name", length = 32, note = "网点类型 网点类型")
    private String clientTypeName;

    @CrmColumn(name = "client_subclass", length = 32, note = "客户细类")
    private String clientSubclass;

    @CrmColumn(name = "client_subclass_name", length = 32, note = "客户细类")
    private String clientSubclassName;

    /**
     * 网点地址
     */
    @CrmColumn(name = "client_address", length = 255, note = "网点地址")
    private String clientAddress;

    /**
     * 网点电话
     */
    @CrmColumn(name = "client_phone", length = 12, note = "网点电话")
    private String clientPhone;

    /**
     * 网点图片
     */
    @CrmColumn(name = "client_photo", length = 255, note = "网点图片")
    private String clientPhoto;

    /**
     * 网点联系人
     */
    @CrmColumn(name = "client_contacts", length = 50, note = "网点联系人")
    private String clientContacts;

    /**
     * 首次拜访日期 首次拜访日期(yyyy-MM-dd)
     */
    @CrmColumn(name = "first_visit_date", length = 32, note = "首次拜访日期 首次拜访日期(yyyy-MM-dd)")
    private String firstVisitDate;

    /**
     * 拜访频率 拜访频率（天/1次）
     */
    @CrmColumn(name = "visit_frequency",  mysqlType = "int(10)", oracleType = "NUMBER(10,0)", note = "拜访频率 拜访频率（天/1次）")
    private Integer visitFrequency;


    /**
     * 经度
     */
    @CrmColumn(name = "longitude", mysqlType = "decimal(32,8)", oracleType = "NUMBER(32,8)", note = "活动编码")
    private BigDecimal longitude;

    /**
     * 纬度
     */
    @CrmColumn(name = "latitude", mysqlType = "decimal(32,8)", oracleType = "NUMBER(32,8)", note = "活动编码")
    private BigDecimal latitude;

    /**
     * 拜访计划编码
     */
    @CrmColumn(name = "visit_plan_code", length = 32, note = "拜访计划编码")
    private String visitPlanCode;

    /**
     * 排序
     */
    @CrmColumn(name = "idx", note = "排序")
    private Integer idx;
}
