package com.biz.crm.visitnote.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitGroupReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitGroupRespVo;
import com.biz.crm.visitnote.model.SfaVisitGroupEntity;

import java.util.List;

/**
 * 线路组管理 接口
 *
 * @author liuhongming
 * @date 2020-09-18 16:53:00
 */
public interface ISfaVisitGroupService extends IService<SfaVisitGroupEntity> {

    /**
     * 列表
     * @param sfaVisitGroupReqVo
     * @return PageResult<SfaVisitGroupRespVo>
     */
    PageResult<SfaVisitGroupRespVo> findList(SfaVisitGroupReqVo sfaVisitGroupReqVo);

    /**
     * 通过id查询详情
     * @param id
     * @return
     */
    SfaVisitGroupRespVo queryDetailById(String id);

    /**
     * 查询
     * @param sfaVisitGroupReqVo
     * @return SfaVisitGroupRespVo
     */
    SfaVisitGroupRespVo query(SfaVisitGroupReqVo sfaVisitGroupReqVo);

    /**
     * 新增
     * @param sfaVisitGroupReqVo
     * @return
     */
    void save(SfaVisitGroupReqVo sfaVisitGroupReqVo);

    /**
     * 更新
     * @param sfaVisitGroupReqVo
     * @return
     */
    void update(SfaVisitGroupReqVo sfaVisitGroupReqVo);

    /**
     * 删除
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @return
     */
    void disableBatch(List<String> ids);
}

