package com.biz.crm.visitnote.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitPlanReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitPlanRespVo;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitnote.model.SfaVisitPlanEntity;

import java.util.List;
import java.util.Map;

/**
 * 拜访计划制定 接口
 *
 * @author liuhongming
 * @date 2020-09-21 14:35:05
 */
public interface ISfaVisitPlanService extends IService<SfaVisitPlanEntity> {

    /**
     * 列表
     * @param sfaVisitPlanReqVo
     * @return PageResult<SfaVisitPlanRespVo>
     */
    PageResult<SfaVisitPlanRespVo> findList(SfaVisitPlanReqVo sfaVisitPlanReqVo);

    /**
     * 通过id查询拜访计划制定详情
     * @param id
     * @return SfaVisitPlanRespVo
     */
    SfaVisitPlanRespVo queryDetailById(String id);

    /**
     * 查询
     * @param sfaVisitPlanReqVo
     * @return SfaVisitPlanRespVo
     */
    SfaVisitPlanRespVo query(SfaVisitPlanReqVo sfaVisitPlanReqVo);

    /**
     * 新增
     * @param sfaVisitPlanReqVo
     * @return
     */
    void save(SfaVisitPlanReqVo sfaVisitPlanReqVo);

    /**
     * 更新
     * @param sfaVisitPlanReqVo
     * @return
     */
    void update(SfaVisitPlanReqVo sfaVisitPlanReqVo);

    /**
     * 删除
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);


    /**
     * 定时任务解析拜访计划
     */
    void resolveVisitPlanForJob();

    /**
     * WEB后台人工触发解析拜访计划
     */
    void resolveVisitPlanForWeb(List<String> visitPlanIds);

    /**
     * <redisHash,<redisHashKey, SfaVisitPlanInfoEntity>>
     * 保存计划明细导redis和ES
     * @param daysPlanInfo
     */
    void saveVisitPlanInfoToRedisAndEs(Map<String, Map<String, SfaVisitPlanInfoEntity>> daysPlanInfo);
}

