package com.biz.crm.visitnote.service.component;


import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitnote.model.SfaVisitPlanEntity;
import com.biz.crm.visitnote.model.SfaVisitPlanRangeEntity;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 拜访计划执行上下文
 *  @author: luoqi
 *  @Date: 2021-2-23 20:25
 *  @version: V1.0
 *  @Description:
 */
public class SfaVisitPlanExecuteContext {
    // #################################  前置数据开始 #############################################
    @Getter
    private boolean dataReady = true;
    @Getter
    @Setter
    private String dataReadyMsg;
    //需要执行的拜访计划
    @Getter
    private Map<String, List<SfaVisitPlanEntity>> userPosMapPlan;

    public void setUserPosMapPlan(Map<String, List<SfaVisitPlanEntity>> userPosMapPlan) {
        this.userPosMapPlan = userPosMapPlan;
        if(CollectionUtils.isEmpty(userPosMapPlan)){
            this.dataReady = false;
            this.dataReadyMsg = "没有可执行的拜访计划配置数据";
        }
    }

    //需要执行的计划范围 planCode -> planRanges
    @Getter
    @Setter
    private Map<String, List<SfaVisitPlanRangeEntity>> planCodeMapPlanRange;

    // #################################  前置数据结束 #############################################


    // #################################  当前正在执行的数据开始 #############################################


    /**
     * 计划配置
     */
    @Getter
    @Setter
    private SfaVisitPlanEntity currentPlanEntity;

    @Getter
    @Setter
    private LocalDate visitDate;
    @Getter
    @Setter
    private LocalDate visitStartDate;
    @Getter
    @Setter
    private LocalDate visitEndDate;
    /**
     * 每个计划(SfaVisitPlanEntity)对应未来每天的计划明细(FuturePlanInfo)
     */
    @Getter
    @Setter
    private Map<String, FuturePlanInfo> planCodeMapFuturePlanInfo = Maps.newHashMap();

    /**
     * 清理正在执行的数据
     */
    public void clean(){
        this.planCodeMapFuturePlanInfo = Maps.newHashMap();
        this.currentPlanEntity = null;
        this.visitDate = null;
        this.visitStartDate = null;
        this.visitEndDate = null;
    }
    // #################################  当前正在执行的数据结束 #############################################



    /**
     * 未来每天的计划明细
     *  @author: luoqi
     *  @Date: 2021-2-25 17:32
     *  @version: V1.0
     *  @Description:
     */
    public static class FuturePlanInfo extends HashMap<String, List<SfaVisitPlanInfoEntity>> {


        /**
         *获取 visitDate 的计划
         * @param visitDate
         */
        public List<SfaVisitPlanInfoEntity> getPlan(LocalDate visitDate){
            if(null == visitDate){
                return Lists.newArrayList();
            }
            List<SfaVisitPlanInfoEntity> data = this.get(visitDate.format(CrmDateUtils.yyyyMMdd));
            if(null == data){
                data = Lists.newArrayList();
            }
            return data;
        }

        /**
         *添加 visitDate 的计划
         * @param newData
         */
        public void putPlan(LocalDate visitDate, List<SfaVisitPlanInfoEntity> newData){

            if(null == visitDate){
                return;
            }
            if(CollectionUtils.isEmpty(newData)){
                return;
            }

            this.put(visitDate.format(CrmDateUtils.yyyyMMdd), newData);
        }

    }
}
