package com.biz.crm.visitnote.service.component.resolver.impl;

import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.SfaClientData;
import com.biz.crm.base.SfaClientHelper;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitPlanRangeReqVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.UUIDGenerator;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitnote.model.SfaVisitPlanEntity;
import com.biz.crm.visitnote.model.SfaVisitPlanRangeEntity;
import com.biz.crm.visitnote.service.component.SfaVisitPlanExecuteContext;
import com.biz.crm.visitnote.service.component.resolver.SfaVisitPlanResolver;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Component;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * 拜访计划解析器 - 网点
 *  @author: luoqi
 *  @Date: 2021-2-23 21:27
 *  @version: V1.0
 *  @Description:
 */
@Component(SfaVisitEnum.routeTypeEnum.outlets + SfaVisitPlanResolver.beanNameSuffix)
public class SfaVisitPlanOutletsResolver extends AbstractSfaVisitPlanResolver {


    @Override
    public void doResolve(SfaVisitPlanExecuteContext context) {
        //本次解析拜访计划未来 SfaVisitPlanResolver.futureDays 天的计划明细
        SfaVisitPlanExecuteContext.FuturePlanInfo futurePlanInfo = new SfaVisitPlanExecuteContext.FuturePlanInfo();
        SfaVisitPlanEntity currentPlanEntity = context.getCurrentPlanEntity();
        while (true){
            //计算下一拜访日期
            LocalDate visitDate = this.visitDateNext(context, futurePlanInfo);
            if(null == visitDate){
                break;
            }
            List<SfaVisitPlanInfoEntity> planInfoEntities = this.produceOutlets(context);
            futurePlanInfo.putPlan(visitDate, planInfoEntities);
        }
        //该拜访计划的未来计划明细
        context.getPlanCodeMapFuturePlanInfo().put(currentPlanEntity.getVisitPlanCode(), futurePlanInfo);

    }

    /**
     * 网点
     * @param context
     * @return
     */
    private List<SfaVisitPlanInfoEntity> produceOutlets(SfaVisitPlanExecuteContext context ) {
        Map<String, List<SfaVisitPlanRangeEntity>> planCodeMapPlanRange = context.getPlanCodeMapPlanRange();
        SfaVisitPlanEntity sfaVisitPlanEntity = context.getCurrentPlanEntity();
        List<SfaVisitPlanRangeEntity> planRangeEntities = planCodeMapPlanRange.get(sfaVisitPlanEntity.getVisitPlanCode());
        List<SfaVisitPlanInfoEntity> planInfoEntities = Lists.newArrayList();
        planRangeEntities.forEach(data -> {

            SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = CrmBeanUtil.copy(sfaVisitPlanEntity, SfaVisitPlanInfoEntity.class);
//            sfaVisitPlanInfoEntity.setId(null);
            sfaVisitPlanInfoEntity.setVisitType(sfaVisitPlanEntity.getPlanType());
            sfaVisitPlanInfoEntity.setVisitTypeName(SfaVisitEnum.visitType.GETMAP.get(sfaVisitPlanEntity.getPlanType()));
            sfaVisitPlanInfoEntity.setClientType(data.getClientType());
            sfaVisitPlanInfoEntity.setClientTypeName(SfaVisitEnum.ClientType.GETMAP.get(sfaVisitPlanInfoEntity.getClientType()));
            sfaVisitPlanInfoEntity.setClientCode(data.getClientCode());
            sfaVisitPlanInfoEntity.setVisitStatus(SfaVisitEnum.visitStatus.V1.getVal());
            sfaVisitPlanInfoEntity.setVisitStatusName(SfaVisitEnum.visitStatus.V1.getDesc());
            sfaVisitPlanInfoEntity.setVisitDate(context.getVisitDate().format(CrmDateUtils.yyyyMMdd));
            sfaVisitPlanInfoEntity.setVisitDateOfYearMonth(context.getVisitDate().format(CrmDateUtils.yyyyMM));
            sfaVisitPlanInfoEntity.setVisitDateOfYear(context.getVisitDate().format(CrmDateUtils.yyyy));
            sfaVisitPlanInfoEntity.setVisitBigType(SfaVisitEnum.VisitBigType.VISIT.getVal());
            sfaVisitPlanInfoEntity.setVisitBigTypeName(SfaVisitEnum.VisitBigType.VISIT.getDesc());
            sfaVisitPlanInfoEntity.setId(UUIDGenerator.generate());
            sfaVisitPlanInfoEntity.setVisitSort(Integer.MAX_VALUE);
            CrmBaseEntity.buildDefEntityData(sfaVisitPlanInfoEntity);
            planInfoEntities.add(sfaVisitPlanInfoEntity);
//            iSfaVisitPlanInfoService.savePeriodicityPlanInfo(planInfoReqVo);
        });
        return planInfoEntities;
    }



}
