package com.biz.crm.visitnote.service.component.resolver.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.SfaClientData;
import com.biz.crm.base.SfaClientHelper;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.UUIDGenerator;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitnote.model.SfaVisitPlanEntity;
import com.biz.crm.visitnote.model.SfaVisitPlanRangeEntity;
import com.biz.crm.visitnote.service.component.SfaVisitPlanExecuteContext;
import com.biz.crm.visitnote.service.component.resolver.SfaVisitPlanResolver;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Component;

import java.time.LocalDate;
import java.time.Period;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * 拜访计划解析器 - 频率
 *  @author: luoqi
 *  @Date: 2021-2-23 21:27
 *  @version: V1.0
 *  @Description:
 */
@Component(SfaVisitEnum.routeTypeEnum.rate + SfaVisitPlanResolver.beanNameSuffix)
public class SfaVisitPlanRateResolver extends AbstractSfaVisitPlanResolver {


    @Override
    public void doResolve(SfaVisitPlanExecuteContext context) {
        //本次解析拜访计划未来 SfaVisitPlanResolver.futureDays 天的计划明细
        SfaVisitPlanExecuteContext.FuturePlanInfo futurePlanInfo = new SfaVisitPlanExecuteContext.FuturePlanInfo();
        SfaVisitPlanEntity currentPlanEntity = context.getCurrentPlanEntity();
        while (true){
            //计算下一拜访日期
            LocalDate visitDate = this.visitDateNext(context, futurePlanInfo);
            if(null == visitDate){
                break;
            }
            List<SfaVisitPlanInfoEntity> planInfoEntities = this.produceRate(context);
            futurePlanInfo.putPlan(visitDate, planInfoEntities);
        }
        //该拜访计划的未来计划明细
        context.getPlanCodeMapFuturePlanInfo().put(currentPlanEntity.getVisitPlanCode(), futurePlanInfo);
    }

    /**
     * 频率
     * @param context
     * @return
     */
    private List<SfaVisitPlanInfoEntity> produceRate(SfaVisitPlanExecuteContext context) {
//        LocalDate startVisitDate = context.getVisitStartDate();
        LocalDate visitDate = context.getVisitDate();
        SfaVisitPlanEntity sfaVisitPlanEntity = context.getCurrentPlanEntity();
        //需要执行的计划范围
        Map<String, List<SfaVisitPlanRangeEntity>> planCodeMapPlanRange = context.getPlanCodeMapPlanRange();
        List<SfaVisitPlanRangeEntity> planRangeEntities = planCodeMapPlanRange.get(sfaVisitPlanEntity.getVisitPlanCode());
        List<SfaVisitPlanInfoEntity> planInfoEntities = Lists.newArrayList();
        for (SfaVisitPlanRangeEntity planRangeEntity : planRangeEntities) {
            //
            if(this.needVisit(planRangeEntity, visitDate)){
                SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = CrmBeanUtil.copy(sfaVisitPlanEntity, SfaVisitPlanInfoEntity.class);
//                sfaVisitPlanInfoEntity.setId(null);
                sfaVisitPlanInfoEntity.setVisitType(sfaVisitPlanEntity.getPlanType());
                sfaVisitPlanInfoEntity.setVisitTypeName(SfaVisitEnum.visitType.GETMAP.get(sfaVisitPlanEntity.getPlanType()));
                sfaVisitPlanInfoEntity.setClientType(planRangeEntity.getClientType());
                sfaVisitPlanInfoEntity.setClientTypeName(SfaVisitEnum.ClientType.GETMAP.get(sfaVisitPlanInfoEntity.getClientType()));
                sfaVisitPlanInfoEntity.setClientCode(planRangeEntity.getClientCode());
                sfaVisitPlanInfoEntity.setVisitStatus(SfaVisitEnum.visitStatus.V1.getVal());
                sfaVisitPlanInfoEntity.setVisitStatusName(SfaVisitEnum.visitStatus.V1.getDesc());
                sfaVisitPlanInfoEntity.setVisitDate(context.getVisitDate().format(CrmDateUtils.yyyyMMdd));
                sfaVisitPlanInfoEntity.setVisitDateOfYearMonth(context.getVisitDate().format(CrmDateUtils.yyyyMM));
                sfaVisitPlanInfoEntity.setVisitDateOfYear(context.getVisitDate().format(CrmDateUtils.yyyy));
                sfaVisitPlanInfoEntity.setVisitBigType(SfaVisitEnum.VisitBigType.VISIT.getVal());
                sfaVisitPlanInfoEntity.setVisitBigTypeName(SfaVisitEnum.VisitBigType.VISIT.getDesc());
                sfaVisitPlanInfoEntity.setVisitSort(Integer.MAX_VALUE);
                sfaVisitPlanInfoEntity.setId(UUIDGenerator.generate());
                CrmBaseEntity.buildDefEntityData(sfaVisitPlanInfoEntity);
                planInfoEntities.add(sfaVisitPlanInfoEntity);
//            iSfaVisitPlanInfoService.savePeriodicityPlanInfo(planInfoReqVo);
            }
        }
        return planInfoEntities;
    }

    /**
     * 是否需要拜访
     * @param planRangeEntity
     * @param visitDate
     * @return
     */
    private boolean needVisit(SfaVisitPlanRangeEntity planRangeEntity, LocalDate visitDate){
        LocalDate firstVisitDate;
        try {
            firstVisitDate = LocalDate.parse(planRangeEntity.getFirstVisitDate(), CrmDateUtils.yyyyMMdd);
        } catch (Exception e) {
            throw new BusinessException("拜访日期格式错误");
        }
        //不算当前日期
        //update: 修改为需要计算当前日期
        Integer visitFrequency = planRangeEntity.getVisitFrequency();
        if (visitDate.compareTo(firstVisitDate) >= 0){
            long days = visitDate.toEpochDay() - firstVisitDate.toEpochDay();
            long difference = days % visitFrequency;
            /*if (!(difference == 0 && days >= visitFrequency)) {
                return false;
            }*/
            return difference == 0 ;
        }else {
            return false;
        }
    }


}
