package com.biz.crm.visitnote.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.achievement.model.SfaAchievementAccomplishRecordEntity;
import com.biz.crm.achievement.service.ISfaAchievementAccomplishRecordService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.SfaClientData;
import com.biz.crm.base.SfaClientHelper;
import com.biz.crm.collection.service.ISfaVisitRoleDirectoryService;
import com.biz.crm.enums.SfaWorkSummaryEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.moblie.controller.visit.req.SfaUnfamiliarTempPlanInfoReq;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitResp;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitPlanRangeReqVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitTempPlanReqVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.*;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.visitinfo.service.impl.SfaVisitPlanInfoServiceEsImpl;
import com.biz.crm.visitnote.req.SfaVisitTempPlanReq;
import com.biz.crm.visitnote.service.ISfaVisitTempPlanService;
import com.biz.crm.visitnote.service.component.resolver.SfaVisitPlanResolver;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * 拜访计划制定 接口实现
 *
 * @author liuhongming
 * @date 2020-09-21 14:35:05
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaVisitTempPlanServiceExpandImpl")
public class SfaVisitTempPlanServiceImpl implements ISfaVisitTempPlanService {

    @Resource
    private ISfaVisitPlanInfoService iSfaVisitPlanInfoService;
    @Resource
    private RedisService redisService;
    @Resource
    private SfaVisitPlanInfoServiceEsImpl sfaVisitPlanInfoServiceEsImpl;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private ISfaVisitRoleDirectoryService sfaVisitRoleDirectoryService;
    @Resource
    private ISfaAchievementAccomplishRecordService sfaAchievementAccomplishRecordService;
    /**
     * 新增临时拜访计划-工作台
     * @param reqVo
     * @return
     */
    @Override
    @Transactional
    public void addTempPlanInfoForWorkbench(SfaVisitTempPlanReqVo reqVo){
        if (StringUtils.isEmpty(reqVo.getVisitUserName())){
            UserRedis userRedis = UserUtils.getUser();
            if (userRedis.getUsertype().equals(UserTypeEnum.CUSTOMER_EMPLOYEE.getCode())){
                userRedis.setPoscode(userRedis.getUsername());
                userRedis.setPosname(userRedis.getRealname());
            }
            reqVo.setVisitUserName(userRedis.getUsername());
            reqVo.setVisitRealName(userRedis.getRealname());
            reqVo.setVisitPosCode(userRedis.getPoscode());
            reqVo.setVisitPosName(userRedis.getPosname());
            reqVo.setVisitOrgCode(userRedis.getOrgcode());
            reqVo.setVisitOrgName(userRedis.getOrgname());
        }
        this.saveCheck(reqVo);
//        SfaVisitPlanEntity entity = CrmBeanUtil.copy(reqVo,SfaVisitPlanEntity.class);
//        String code = CodeUtil.getCodeDefault();
//        String code = CodeUtil.generateCode(SfaCodeEnum.VisitPLanCode.SFA_VISIT_OUTLETS_CODE.getVal());
//        entity.setVisitPlanCode(code);
//        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        //计划配置数据
//        this.save(entity);
//        this.saveData(reqVo, entity);
        //新增临时拜访计划到redis
        this.addPlanInfoForTempPlan(reqVo);



    }
    /**
     * 工作台-新增临时拜访计划
     * @param reqVo
     */
    private void addPlanInfoForTempPlan(SfaVisitTempPlanReqVo reqVo){
        List<SfaVisitPlanInfoEntity> planInfoEntities = Lists.newArrayList();
        List<SfaVisitPlanRangeReqVo> sfaVisitPlanRangeReqVos = reqVo.getSfaVisitPlanRangeReqVos();

        List<String> customerCodes = sfaVisitPlanRangeReqVos.stream().filter(v -> SfaVisitEnum.ClientType.DEALER.getVal().equals(v.getClientType())).map(SfaVisitPlanRangeReqVo :: getClientCode).collect(Collectors.toList());
        List<String> terminalCodes = sfaVisitPlanRangeReqVos.stream().filter(v -> SfaVisitEnum.ClientType.TERMINAL.getVal().equals(v.getClientType())).map(SfaVisitPlanRangeReqVo :: getClientCode).collect(Collectors.toList());
        Map<String, SfaClientData> clientDataMap = SfaClientHelper.loadClientDataMap(customerCodes, terminalCodes);
        for (SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo : sfaVisitPlanRangeReqVos) {
            SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = CrmBeanUtil.copy(reqVo,SfaVisitPlanInfoEntity.class);
            SfaClientData clientData = clientDataMap.get(sfaVisitPlanRangeReqVo.getClientType() + sfaVisitPlanRangeReqVo.getClientCode());
            if(null == clientData){
                throw new BusinessException("不存在的客户数据[" + sfaVisitPlanRangeReqVo.getClientCode() + "]");
            }
            SfaVisitPlanInfoEntity.copyClientData(sfaVisitPlanInfoEntity, clientData);
            sfaVisitPlanInfoEntity.setVisitStatus(SfaVisitEnum.visitStatus.V1.getVal());
            sfaVisitPlanInfoEntity.setVisitStatusName(SfaVisitEnum.visitStatus.V1.getDesc());
            sfaVisitPlanInfoEntity.setVisitDate(reqVo.getVisitStartDate());
            LocalDate date = LocalDate.parse(reqVo.getVisitStartDate(), CrmDateUtils.yyyyMMdd);
            sfaVisitPlanInfoEntity.setVisitDateOfYearMonth(date.format(CrmDateUtils.yyyyMM));
            sfaVisitPlanInfoEntity.setVisitDateOfYear(date.format(CrmDateUtils.yyyy));
            sfaVisitPlanInfoEntity.setVisitType(SfaVisitEnum.visitType.TEMP_VISIT.getVal());
            sfaVisitPlanInfoEntity.setVisitTypeName(SfaVisitEnum.visitType.TEMP_VISIT.getDesc());
            //没有计划编码，用临时类型编码占位
            sfaVisitPlanInfoEntity.setVisitPlanCode(SfaVisitEnum.visitType.TEMP_VISIT.getVal());
            sfaVisitPlanInfoEntity.setRouteType(SfaVisitEnum.routeTypeEnum.R2.getVal());
            sfaVisitPlanInfoEntity.setVisitBigType(SfaVisitEnum.VisitBigType.VISIT.getVal());
            sfaVisitPlanInfoEntity.setVisitBigTypeName(SfaVisitEnum.VisitBigType.VISIT.getDesc());

            sfaVisitPlanInfoEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            sfaVisitPlanInfoEntity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            sfaVisitPlanInfoEntity.setId(UUIDGenerator.generate());
            CrmBaseEntity.buildDefEntityData(sfaVisitPlanInfoEntity);
            planInfoEntities.add(sfaVisitPlanInfoEntity);
        }
        this.doAddPlanInfoForTempPlan(planInfoEntities);
    }
    /**
     * 新增临时拜访计划-陌拜
     * @param sfaUnfamiliarTempPlanInfoReq
     */
    @Override
    public SfaVisitResp.SfaVisitPlanInfoResp addTempPlanInfoForUnfamiliar(SfaUnfamiliarTempPlanInfoReq sfaUnfamiliarTempPlanInfoReq){

        if(StringUtils.isEmpty(sfaUnfamiliarTempPlanInfoReq.getAmapId())){
            throw new BusinessException("地图ID为空");
        }
        if(StringUtils.isEmpty(sfaUnfamiliarTempPlanInfoReq.getClientName())){
            throw new BusinessException("客户名称为空");
        }
        if(StringUtils.isEmpty(sfaUnfamiliarTempPlanInfoReq.getClientAddress())){
            throw new BusinessException("地址为空");
        }
        if(StringUtils.isEmpty(sfaUnfamiliarTempPlanInfoReq.getLongitude())){
            throw new BusinessException("经度为空");
        }
        if(StringUtils.isEmpty(sfaUnfamiliarTempPlanInfoReq.getLatitude())){
            throw new BusinessException("纬度为空");
        }

        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = CrmBeanUtil.copy(sfaUnfamiliarTempPlanInfoReq, SfaVisitPlanInfoEntity.class);
        //陌拜类型
        sfaVisitPlanInfoEntity.setVisitBigType(SfaVisitEnum.VisitBigType.UNFAMILIAR_VISIT.getVal());
        sfaVisitPlanInfoEntity.setVisitBigTypeName(SfaVisitEnum.VisitBigType.UNFAMILIAR_VISIT.getDesc());

        sfaVisitPlanInfoEntity.setClientCode(sfaUnfamiliarTempPlanInfoReq.getAmapId());
        sfaVisitPlanInfoEntity.setClientName(sfaUnfamiliarTempPlanInfoReq.getClientName());
        //陌拜固定为终端类型
        sfaVisitPlanInfoEntity.setClientType(SfaVisitEnum.ClientType.TERMINAL.getVal());
        sfaVisitPlanInfoEntity.setClientTypeName(SfaVisitEnum.ClientType.TERMINAL.getDesc());
        this.doAddTempPlanInfoForNearby(sfaVisitPlanInfoEntity);
        SfaVisitResp.SfaVisitPlanInfoResp SfaVisitPlanInfoResp = CrmBeanUtil.copy(sfaVisitPlanInfoEntity, SfaVisitResp.SfaVisitPlanInfoResp.class);
        this.sfaVisitRoleDirectoryService.buildSfaVisitPlanInfoFormId(SfaVisitPlanInfoResp, sfaVisitPlanInfoEntity.getVisitPosCode());
        return SfaVisitPlanInfoResp;
    }

    /**
     * 获取今日拜访数
     *
     * @return java.lang.Integer
     * @method getVisitNum
     * @date: 2021/4/1 15:31
     * @author: YuanZiJian
     */
    @Override
    public Integer getVisitNum(String dateFlag) {
        AssertUtils.isNotEmpty(dateFlag,"请传入查询时间范围类型——本日、本周、本月");
        UserRedis user = UserUtils.getUser();
        LocalDate nowTime = LocalDate.now();
        LambdaQueryWrapper<SfaAchievementAccomplishRecordEntity> queryWrapper = Wrappers.lambdaQuery(SfaAchievementAccomplishRecordEntity.class)
                .eq(SfaAchievementAccomplishRecordEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode())
                .eq(SfaAchievementAccomplishRecordEntity::getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode())
                .eq(SfaAchievementAccomplishRecordEntity::getIndexCode, SfaVisitEnum.indexType.WDBF.getCode())
                .eq(SfaAchievementAccomplishRecordEntity::getUsername,user.getUsername());
        //今日
        if(SfaWorkSummaryEnum.dateFlag.TODAY.getCode().equals(dateFlag)){
            String dayTime = nowTime.format(CrmDateUtils.yyyyMMdd);
            queryWrapper.eq(SfaAchievementAccomplishRecordEntity::getCreateDate , dayTime);
        }
        //本周
        if(SfaWorkSummaryEnum.dateFlag.WEEK.getCode().equals(dateFlag)){
            //本周第一天
            String weekTime = nowTime.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).format(CrmDateUtils.yyyyMMdd);
            //当前日期
            String nowDayTime = nowTime.format(CrmDateUtils.yyyyMMdd);
            queryWrapper.between(SfaAchievementAccomplishRecordEntity::getCreateDate,weekTime,nowDayTime);
        }
        //本月
        if(SfaWorkSummaryEnum.dateFlag.MONTH.getCode().equals(dateFlag)){
            String monthTime = nowTime.format(DateTimeFormatter.ofPattern("yyyy-MM"));
            queryWrapper.like(SfaAchievementAccomplishRecordEntity::getCreateDate , monthTime);
        }
        int count = sfaAchievementAccomplishRecordService.count(queryWrapper);
        return count;
    }

    /**
     * 新增临时拜访计划-附近客户
     * @param sfaVisitTempPlanReq
     */
    @Override
    public SfaVisitResp.SfaVisitPlanInfoResp addTempPlanInfoForNearby(SfaVisitTempPlanReq sfaVisitTempPlanReq){
        if(StringUtils.isEmpty(sfaVisitTempPlanReq.getClientCode())){
            throw new BusinessException("客户编码为空");
        }
        if(StringUtils.isEmpty(sfaVisitTempPlanReq.getClientType())){
            throw new BusinessException("客户类型为空");
        }
        SfaClientData clientData = SfaClientHelper.loadClientData(sfaVisitTempPlanReq.getClientType(), sfaVisitTempPlanReq.getClientCode());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = CrmBeanUtil.copy(clientData, SfaVisitPlanInfoEntity.class);
        //拜访类型
        sfaVisitPlanInfoEntity.setVisitBigType(SfaVisitEnum.VisitBigType.VISIT.getVal());
        sfaVisitPlanInfoEntity.setVisitBigTypeName(SfaVisitEnum.VisitBigType.VISIT.getDesc());

        this.doAddTempPlanInfoForNearby(sfaVisitPlanInfoEntity);
        SfaVisitResp.SfaVisitPlanInfoResp SfaVisitPlanInfoResp = CrmBeanUtil.copy(sfaVisitPlanInfoEntity, SfaVisitResp.SfaVisitPlanInfoResp.class);
        this.sfaVisitRoleDirectoryService.buildSfaVisitPlanInfoFormId(SfaVisitPlanInfoResp, sfaVisitPlanInfoEntity.getVisitPosCode());
        return SfaVisitPlanInfoResp;
    }

    /**
     * 新增临时拜访计划-附近客户/陌拜
     * @param sfaVisitPlanInfoEntity
     * @return
     */
    private SfaVisitPlanInfoEntity doAddTempPlanInfoForNearby(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity){
        UserRedis userRedis = UserUtils.getUser();
        sfaVisitPlanInfoEntity.setId(UUIDGenerator.generate());
        sfaVisitPlanInfoEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        sfaVisitPlanInfoEntity.setVisitUserName(userRedis.getUsername());
        sfaVisitPlanInfoEntity.setVisitRealName(userRedis.getRealname());
        sfaVisitPlanInfoEntity.setVisitPosCode(userRedis.getPoscode());
        sfaVisitPlanInfoEntity.setVisitPosName(userRedis.getPosname());
        sfaVisitPlanInfoEntity.setVisitOrgCode(userRedis.getOrgcode());
        sfaVisitPlanInfoEntity.setVisitOrgName(userRedis.getOrgname());
        MdmOrgRespVo mdmOrgRespVo = OrgUtil.getOrgByCode(userRedis.getOrgcode());
        if(null != mdmOrgRespVo){
            sfaVisitPlanInfoEntity.setParentOrgCode(mdmOrgRespVo.getParentCode());
            sfaVisitPlanInfoEntity.setParentOrgName(mdmOrgRespVo.getParentName());
        }
        sfaVisitPlanInfoEntity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        sfaVisitPlanInfoEntity.setVisitPlanCode(SfaVisitEnum.visitType.TEMP_VISIT.getVal());
        sfaVisitPlanInfoEntity.setRouteType(SfaVisitEnum.routeTypeEnum.R2.getVal());
        sfaVisitPlanInfoEntity.setVisitType(SfaVisitEnum.visitType.TEMP_VISIT.getVal());
        sfaVisitPlanInfoEntity.setVisitTypeName(SfaVisitEnum.visitType.TEMP_VISIT.getDesc());
        sfaVisitPlanInfoEntity.setVisitStatus(SfaVisitEnum.visitStatus.V1.getVal());
        sfaVisitPlanInfoEntity.setVisitStatusName(SfaVisitEnum.visitStatus.V1.getDesc());
        LocalDate date = LocalDate.now();
        sfaVisitPlanInfoEntity.setVisitDate(date.format(CrmDateUtils.yyyyMMdd));
        sfaVisitPlanInfoEntity.setVisitDateOfYearMonth(date.format(CrmDateUtils.yyyyMM));
        sfaVisitPlanInfoEntity.setVisitDateOfYear(date.format(CrmDateUtils.yyyy));

        CrmBaseEntity.buildDefEntityData(sfaVisitPlanInfoEntity);


        this.doAddPlanInfoForTempPlan(Lists.newArrayList(sfaVisitPlanInfoEntity));
        return sfaVisitPlanInfoEntity;
    }


    private void doAddPlanInfoForTempPlan(List<SfaVisitPlanInfoEntity> planInfoEntities){
        //2021-12-15  修改(陌拜已有计划问题)
        String redisHash = iSfaVisitPlanInfoService.checkAddForTempPlan(planInfoEntities);
//        String redisHash = iSfaVisitPlanInfoService.checkForTempPlan(planInfoEntities);
        this.sfaVisitPlanInfoServiceEsImpl.saveAll(planInfoEntities);
//        SfaVisitPlanInfoEntity temp = planInfoEntities.get(0);
//        planInfoEntities = this.sfaVisitPlanInfoServiceEsImpl.findByVisitUserNameAndVisitPosCodeAndAndVisitDateAndVisitBigType
//                (temp.getVisitUserName(), temp.getVisitPosCode(), temp.getVisitDate(), temp.getVisitBigType());
        Map<String, SfaVisitPlanInfoEntity> map = planInfoEntities.stream().collect(Collectors.toMap(SfaVisitPlanInfoEntity :: getRedisHashKey, v -> v, (t, t2) -> t2));
        this.redisService.hmset(redisHash, map, SfaVisitPlanInfoEntity.CACHE_TIME);
    }

    public void saveCheck(SfaVisitTempPlanReqVo reqVo){
        AssertUtils.isNotEmpty(reqVo.getPlanType(),"拜访类型不能为空");
        if (!SfaVisitEnum.visitType.GETMAP.containsKey(reqVo.getPlanType())){
            throw new BusinessException("拜访类型有误,不存在该拜访类型(临时拜访、计划拜访、协访)");
        }
        AssertUtils.isNotEmpty(reqVo.getRouteType(),"维度类型不能为空(线路组、网点、频率)");
        if (!SfaVisitEnum.routeTypeEnum.GETMAP.containsKey(reqVo.getRouteType())){
            throw new BusinessException("维度类型有误,不存在该维度(线路组、网点、频率)");
        }
        AssertUtils.isNotEmpty(reqVo.getVisitUserName(),"人员编码不能为空");
        AssertUtils.isNotEmpty(reqVo.getVisitRealName(),"请选择人员姓名");
        AssertUtils.isNotEmpty(reqVo.getVisitPosCode(),"人员职位编码不能为空");
        AssertUtils.isNotEmpty(reqVo.getVisitPosName(),"人员职位名称不能为空");
        AssertUtils.isNotEmpty(reqVo.getVisitOrgCode(),"人员所属组织编码不能为空");
        AssertUtils.isNotEmpty(reqVo.getVisitOrgName(),"人员所属组织名称不能为空");
        AssertUtils.isNotEmpty(reqVo.getVisitStartDate(),"临时拜访日期不能为空");
        LocalDate beginDate;
        try{
            beginDate = LocalDate.parse(reqVo.getVisitStartDate(),CrmDateUtils.yyyyMMdd);
            SfaVisitPlanResolver.futureDaysCheck(beginDate);
        }catch(BusinessException e){
            throw e;
        }catch(Exception e){
            throw new BusinessException("临时拜访日期格式错误", e);
        }
        reqVo.setVisitEndDate(reqVo.getVisitStartDate());



        if (!CollectionUtil.listNotEmpty(reqVo.getSfaVisitPlanRangeReqVos())){
            throw new BusinessException("拜访计划制定范围不能为空");
        }
        int i = 1;
        for (SfaVisitPlanRangeReqVo sfaVisitPlanRangeReqVo:reqVo.getSfaVisitPlanRangeReqVos()){
            if (SfaVisitEnum.routeTypeEnum.R1.getVal().equals(reqVo.getRouteType())){
                AssertUtils.isNotEmpty(sfaVisitPlanRangeReqVo.getVisitGroupId(),"线路组"+i+",线路组id不能为空");
                AssertUtils.isNotEmpty(sfaVisitPlanRangeReqVo.getVisitGroupName(),"线路组"+i+",线路组名称不能为空");
            }else {
//                AssertUtils.isNotEmpty(sfaVisitPlanRangeReqVo.getClientId(),"第"+i+"行,客户id不能为空");
                AssertUtils.isNotEmpty(sfaVisitPlanRangeReqVo.getClientCode(),"第"+i+"行,客户编码不能为空");
                AssertUtils.isNotEmpty(sfaVisitPlanRangeReqVo.getClientName(),"第"+i+"行,客户名称不能为空");
                AssertUtils.isNotEmpty(sfaVisitPlanRangeReqVo.getClientType(),"第"+i+"行,客户类型不能为空");
                if (SfaVisitEnum.routeTypeEnum.R3.getVal().equals(reqVo.getRouteType())){
                    AssertUtils.isNotEmpty(sfaVisitPlanRangeReqVo.getFirstVisitDate(),"第"+i+"行,首次拜访日期不能为空");
                    LocalDate firstVisitDate = null;
                    try{
                        firstVisitDate = LocalDate.parse(sfaVisitPlanRangeReqVo.getFirstVisitDate(),CrmDateUtils.yyyyMMdd);
                    }catch(Exception e){
                        throw new BusinessException("第"+i+"行,首次拜访日期格式错误", e);
                    }
                    if (beginDate.isAfter(firstVisitDate) || firstVisitDate.isAfter(beginDate)){
                        throw new BusinessException("第"+i+"行,首次拜访日不在循环日期内");
                    }
                    if (null == sfaVisitPlanRangeReqVo.getVisitFrequency()){
                        throw new BusinessException("第"+i+"行,拜访频率不能为空");
                    }
                    try{
                        String regex="^[1-9]+[0-9]*$";
                        Pattern p=Pattern.compile(regex);
                        Matcher m=p.matcher(sfaVisitPlanRangeReqVo.getVisitFrequency().toString());
                        if(!m.find()){
                            System.out.println("falsss");
                            throw new BusinessException("第"+i+"行,拜访频率必须是大于0的整数");
                        }
                    }catch(Exception e){
                        throw new BusinessException("第"+i+"行,拜访频率必须是大于0的整数", e);
                    }
                    if (sfaVisitPlanRangeReqVo.getVisitFrequency() <= 0){
                        throw new BusinessException("第"+i+"行,拜访频率必须是大于0的整数");
                    }
                }
            }
            i++;
        }
    }










}
